import codecs
import os
import sys

preload_app = True
proc_name = 'avia-stat-admin'

bind = os.getenv('BIND_ADDRESS')
workers = int(os.getenv('GUNICORN_WORKERS_COUNT', 4))

max_requests = int(os.getenv('GUNICORN_MAX_REQUESTS', 100))
max_requests_jitter = max_requests // 5

timeout = int(os.getenv('GUNICORN_TIMEOUT', 60))
graceful_timeout = timeout

limit_request_line = 8190


def post_fork(server, worker):
    from travel.avia.stat_admin.local_settings import LOG_PATH
    stdout_path = os.path.join(LOG_PATH, 'gunicorn_stdout.log')
    stderr_path = os.path.join(LOG_PATH, 'gunicorn_stderr.log')

    sys.stdout = codecs.open(stdout_path, 'a', encoding='utf-8', errors='replace')
    sys.stderr = codecs.open(stderr_path, 'a', encoding='utf-8', errors='replace')
