# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.utils.timezone
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ActiveJob',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('started', models.DateTimeField(default=django.utils.timezone.now, db_index=True)),
                ('ended', models.DateTimeField(null=True, blank=True)),
                ('title', models.CharField(default=b'Common task', max_length=256)),
                ('state', models.CharField(default=b'Starting', max_length=256)),
                ('percent', models.PositiveSmallIntegerField(default=0)),
                ('success', models.NullBooleanField()),
                ('script', models.CharField(default=b'', max_length=128, db_index=True)),
                ('params', models.TextField(default=b'')),
                ('binary', models.BinaryField(null=True, blank=True)),
                ('user', models.ForeignKey(to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['success', '-started'],
            },
        ),
    ]
