from django.utils import timezone

from django.db import models
from django.contrib.auth.models import User


class ActiveJob(models.Model):
    user = models.ForeignKey(User)
    started = models.DateTimeField(default=timezone.now, db_index=True)
    ended = models.DateTimeField(blank=True, null=True)
    title = models.CharField(max_length=256, default='Common task')
    state = models.CharField(max_length=256, default='Starting')
    percent = models.PositiveSmallIntegerField(default=0)
    success = models.NullBooleanField(null=True, blank=True)
    script = models.CharField(max_length=128, null=False, blank=False, default='', db_index=True)
    params = models.TextField(null=False, blank=False, default='')
    binary = models.BinaryField(null=True, blank=True)

    class Meta:
        ordering = ['success', '-started']
