# coding: utf-8

import csv
from StringIO import StringIO
from collections import defaultdict
from urlparse import urlparse, parse_qs

from googleads import adwords


def add_query_params_to_report(report, urls):
    for url in urls:
        for key, value in parse_qs(urlparse(url).query).iteritems():
            report[key] |= set(value)


class AdwordsReport(object):
    def __init__(self, settings):
        self.adwords_client = adwords.AdWordsClient.LoadFromStorage(settings)

    def get_adwords_report(self, operations, date_range_type):
        report_template = {
            "reportName": "name",
            "dateRangeType": date_range_type,
            "downloadFormat": "CSV",
        }
        operations.update(report_template)

        f = StringIO()
        downloader = self.adwords_client.GetReportDownloader()
        downloader.DownloadReport(operations, output=f)
        result = csv.reader(StringIO(f.getvalue()), delimiter=',')
        return list(result)[2:-1]

    def get_campaing_utm_params(self, date_range_type):
        campaign_performance_report_operations = {
            "reportType": "CAMPAIGN_PERFORMANCE_REPORT",
             'selector': {
                 'fields': [
                     "CampaignName", "CampaignId", "Cost", "Clicks", "Impressions", "TrackingUrlTemplate", "UrlCustomParameters",
                 ],
             }
        }

        other_reports_operations = [
            {"reportType": "FINAL_URL_REPORT",
             'selector': {
                 'fields': [
                     "CampaignName", "CampaignId", "EffectiveFinalUrl", "EffectiveTrackingUrlTemplate",
                 ],
             }},
            {"reportType": "AD_PERFORMANCE_REPORT",
             'selector': {
                 'fields': [
                     "CampaignName", "CampaignId", "CreativeFinalUrls", "CreativeDestinationUrl",
                     "CreativeTrackingUrlTemplate", "CreativeUrlCustomParameters", "DisplayUrl"
                 ],
             }},
            {"reportType": "SEARCH_QUERY_PERFORMANCE_REPORT",
             'selector': {
                 'fields': [
                     "CampaignName", "CampaignId", "DestinationUrl", "FinalUrl", "TrackingUrlTemplate",
                 ],
             }},
        ]

        campaign_performance_report = self.get_adwords_report(campaign_performance_report_operations, date_range_type)

        cost_report = defaultdict(lambda: {
            "cost": 0, "clicks": 0, "impressions": 0, "utm_params": defaultdict(set),
        })

        for row in campaign_performance_report[2:-1]:
            campaing_id = row[1]
            cost_report[campaing_id]["campaing_name"] = row[0]
            cost_report[campaing_id]["cost"] += int(row[2])
            cost_report[campaing_id]["clicks"] += int(row[3])
            cost_report[campaing_id]["impressions"] += int(row[4])
            add_query_params_to_report(cost_report[campaing_id]["utm_params"], row[5: 7])

        for report_operations in other_reports_operations:
            for row in self.get_adwords_report(report_operations, date_range_type):
                campaing_id = row[1]
                if campaing_id in cost_report:
                    add_query_params_to_report(cost_report[campaing_id]["utm_params"], row[2:])

        result = []

        for key, value in cost_report.iteritems():
            utm_campaigns = value['utm_params'].get('utm_campaign')
            utm_source = value['utm_params'].get('utm_source')
            result.append({
                'campaing_id': key,
                'campaing_name': value['campaing_name'],
                'utm_params': {k: list(v)[0] for k, v in value['utm_params'].iteritems()},
                'utm_campaign': None if utm_campaigns is None else list(utm_campaigns)[0],
                'utm_source': None if utm_source is None else list(utm_source)[0],
                'cost': value["cost"],
                'clicks': value["clicks"],
                'impressions': value["impressions"],
            })

        return result
