import base64

from django.http import HttpResponse
import logging
log = logging.getLogger(__name__)


def view_or_basicauth(view, request, login_to_password, *args, **kwargs):
    if 'HTTP_AUTHORIZATION' in request.META:
        auth = request.META['HTTP_AUTHORIZATION'].split()
        if len(auth) == 2:
            if auth[0].lower() == "basic":
                uname, passwd = base64.b64decode(auth[1]).split(':')

                if login_to_password.get(uname) == passwd:
                    return view(request, *args, **kwargs)

    return HttpResponse(status=401)


def basicauth(login_to_password, view_func):
    def wrapper(request, *args, **kwargs):
        return view_or_basicauth(view_func, request, login_to_password, *args, **kwargs)
    return wrapper
