# -*- coding: utf-8 -*-
import subprocess
import os
import threading
import tempfile
import zipfile
from cStringIO import StringIO

from django.conf import settings
from django.utils import timezone

from travel.avia.stat_admin.job.models import ActiveJob


def run_task_in_thread(*args, **kwargs):
    t = threading.Thread(target=run_task,
                         args=args,
                         kwargs=kwargs)
    t.setDaemon(True)
    t.start()


def run_task(user, title, script, params):
    script_path = '%s/%s.py' % (settings.SCRIPTS_PATH, script)
    params_list = ['python', script_path]

    new_job = ActiveJob(
        user=user,
        title=title,
        state='Starting',
        script=script,
        params=' '.join(['%s' % k if not v else '%s %s' % (k, v) for k, v in params.items()]),
    )

    new_job.save()

    params['-j'] = str(new_job.id)

    for k, v in params.items():
        params_list.append(str(k))

        if v:
            params_list.append(str(v))

    try:
        subprocess.check_call(params_list)
        state = 'Finished'
        sucess = True

    except Exception as e:
        state = 'Failed: %s' % e.message
        sucess = False

    new_job.ended = timezone.now()
    new_job.success = sucess
    new_job.state = state
    new_job.binary = get_zipped_results(new_job.id)

    new_job.save()


def get_job_dir(job_id):
    if job_id:
        storage_root = settings.JOB_STORAGE_ROOT

    else:
        storage_root = tempfile.gettempdir()

    job_dir = os.path.join(
        storage_root,
        str(job_id)
    )

    return job_dir


def get_or_create_job_storage_dir(job_id, create_if_exists=True):
    job_dir = get_job_dir(job_id)

    if create_if_exists and not os.path.exists(job_dir):
        os.makedirs(job_dir)

    return job_dir


def get_zipped_results(job_id):
    job_files_dir = get_job_dir(job_id)

    file_names = []
    for f in os.listdir(job_files_dir):
        file_name = os.path.join(job_files_dir, f)
        if os.path.isfile(file_name):
            file_names.append(file_name)

    zip_subdir = 'avia-stats-%s' % job_id

    s = StringIO()
    zf = zipfile.ZipFile(s, "w", compression=zipfile.ZIP_DEFLATED)

    for fpath in file_names:
        fdir, fname = os.path.split(fpath)
        zip_path = os.path.join(zip_subdir, fname)
        zf.write(fpath, zip_path)

    zf.close()

    return s.getvalue()
