from travel.avia.stat_admin.data.models import Settlement, Airport


def get_point_by_point_key(point_key):
    try:
        return _get_point_by_point_key(point_key)
    except Exception:
        return None


def _get_point_by_point_key(point_key):
    if not point_key:
        return None

    model_type = point_key[0]
    id_value = int(point_key[1:])

    model = {'c': Settlement, 's': Airport}[model_type]
    return model.objects.filter(avia_id=id_value).first()
