from travel.avia.stat_admin.data.models import PartnerReview
from travel.avia.stat_admin.lib.title_index import TitleIndex, title_index


class ReviewFilter(object):
    DELIMITER = ','

    def __init__(self, title_index, ModelClass):
        # type: (TitleIndex, any) -> None
        self._title_index = title_index
        self._ModelClass = ModelClass

    def search(self, query, query_set):
        params = self._parse(query)

        query_set, has_modified = self._filter(
            params, query_set
        )

        if not has_modified and params:
            return self._ModelClass.objects.none()
        return query_set

    def _filter(self, params, query_set):
        has_modified = False

        from_name = params.pop('from_name', None)
        to_name = params.pop('to_name', None)

        if from_name:
            point_key = self._title_index.find(from_name)

            query_set = query_set.filter(point_from=point_key)
            has_modified = True

        if to_name:
            point_key = self._title_index.find(to_name)

            query_set = query_set.filter(point_to=point_key)
            has_modified = True

        if 'wizard_redir_key' in params:
            if params['wizard_redir_key'].lower() == 'with':
                query_set =query_set.exclude(wizard_redir_key='')
                query_set = query_set.exclude(wizard_redir_key__isnull=True)
                has_modified = True
                params.pop('wizard_redir_key')

        if params:
            query_set = query_set.filter(**params)
            has_modified = True

        return query_set, has_modified

    def _parse(self, query):
        tokens = query.strip().split(ReviewFilter.DELIMITER)

        type_name_to_value = {}

        code_to_type_name = {
            'f': 'from_name',
            't': 'to_name',
            'k': 'wizard_redir_key'
        }
        for t in tokens:
            subtokens = [
                s.strip() for s in t.split('=')
            ]
            if len(subtokens) != 2:
                continue
            code, value = subtokens

            if code not in code_to_type_name:
                continue
            type_name_to_value[code_to_type_name[code]] = value

        return type_name_to_value


partner_review_filter = ReviewFilter(
    title_index=title_index,
    ModelClass=PartnerReview
)
