# -*- coding: utf-8 -*-
from django.conf import settings

from travel.avia.stat_admin.job.models import ActiveJob


def get_active_jobs(user):
    jobs = ActiveJob.objects.filter(
        user_id=user.id,
        success__isnull=True
    ).order_by(
        '-id'
    )

    return jobs


def add_common_context(request, context):
    active_jobs_count = len(get_active_jobs(request.user))

    context['active_jobs_count'] = active_jobs_count

    if settings.YANDEX_ENVIRONMENT_TYPE == 'production':
        context['project_title'] = 'Авиа статистика'
    else:
        context['project_title'] = 'Авиа статистика: TEST/DEV'
