from collections import defaultdict
from typing import Optional

from travel.avia.stat_admin.data.models import Settlement, Airport


class TitleIndex(object):
    def __init__(self):
        self._settlement_index = None
        self._airport_index = None
        self._counter = 0

    def _fetch_settlement(self):
        result = defaultdict(list)

        for d in Settlement.objects.values('avia_id', 'title'):
            result[d['title'].strip().lower()].append(
                'c{}'.format(d['avia_id']))

        self._settlement_index = dict(result)

    def _fetch_station(self):
        result = defaultdict(list)

        for d in Airport.objects.values('avia_id', 'title'):
            result[d['title'].strip().lower()].append(
                's{}'.format(d['avia_id']))

        self._airport_index = dict(result)

    def _need_refetch_index(self):

        return (
            self._airport_index is None or
            self._settlement_index is None or
            self._counter > 100
        )

    def find(self, title):
        # type: (str) -> Optional[str]
        if self._need_refetch_index():
            self._fetch_settlement()
            self._fetch_station()
            self._counter = 0
        self._counter += 1

        title = title.strip().lower()

        variants = self._settlement_index.get(title)
        if variants:
            return variants[0]

        variants = self._airport_index.get(title)

        if variants:
            return variants[0]
        return None


title_index = TitleIndex()
