# -*- coding: utf-8 -*-
# flake8: noqa: F405
import os
import socket

from django_idm_api.settings import *  # noqa
from library.python.django.utils import patch_settings_for_arcadia
from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI, MYSQL_API_BASE_URL

from travel.avia.stat_admin.settings.environment import EnvironmentType, YANDEX_ENVIRONMENT_TYPE # noqa
from travel.avia.stat_admin.data.settings import *  # noqa
from travel.avia.stat_admin.rest.settings import *  # noqa

os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'

DEBUG = True

CURRENT_DC = os.getenv('CURRENT_DC', os.getenv('DEPLOY_NODE_DC', '').lower())

LOG_PATH = os.getenv('LOG_PATH')
LOGGING = create_logging(LOG_PATH)

PKG_VERSION = os.getenv('DEPLOY_DOCKER_IMAGE') or 'dev'

# Все очень устарело, но это окружение еще живое
if YANDEX_ENVIRONMENT_TYPE == EnvironmentType.PRODUCTION:
    RASP_API_HOST = 'http://int-api.avia.yandex.net/'
else:
    RASP_API_HOST = 'http://int-api.avia.tst.yandex.net/'

TOP_DIRECTIONS_SOURCE_PATH = '//home/rasp/logs/rasp-users-search-log'

SERVER_EMAIL = 'AVIA-STAT at %s <rasp-tech@yandex-team.ru>' % socket.gethostname()

PROJECT_PATH = os.path.normpath(os.path.abspath(os.path.dirname(__file__)))
SCRIPTS_PATH = os.path.normpath(os.path.join(PROJECT_PATH, 'scripts'))
JOB_STORAGE_ROOT = os.path.join(PROJECT_PATH, 'static/avia-stats/media/job')
REPORTS_STORAGE_ROOT = os.path.join(PROJECT_PATH, 'static/avia-stats/media/reports')

ALLOWED_HOSTS = ['*']

DATABASES['default']['NAME'] = os.getenv('AVIA_MYSQL_DB_NAME', 'avia_stats')

if YANDEX_ENVIRONMENT_TYPE == EnvironmentType.DEVELOPMENT:
    DATABASES['default']['HOST'] = os.getenv('DB_HOST', 'localhost')
else:
    _cluster_id = os.getenv('AVIA_MYSQL_CLUSTER_ID')
    mdb_api = MdbAPI(
        api_base_url=MYSQL_API_BASE_URL,
        oauth_token=os.getenv('AVIA_MDB_API_TOKEN'),
    )

    master_cname = 'c-{}.rw.db.yandex.net'.format(_cluster_id)
    mdb_api.add_default_cluster_info(
        cluster_id=_cluster_id,
        master_hostname=master_cname,
        hostnames=['c-{}.ro.db.yandex.net'.format(_cluster_id)],
    )
    cluster_info = mdb_api.get_cluster_info(_cluster_id)
    cluster_info.sort_replicas(CURRENT_DC)

    DATABASES['default']['HOST'] = master_cname
    DATABASES['default']['REPLICAS'] = cluster_info.replicas + [cluster_info.master]

DATABASES['default']['USER'] = os.getenv('AVIA_MYSQL_DB_USER')
DATABASES['default']['PASSWORD'] = os.getenv('AVIA_MYSQL_DB_PASSWORD')

ENABLE_TOPIC_LOG = False
ENABLE_YT_DELIVERY = False
LB_CLIENT_ID = os.getenv('LB_CLIENT_ID', None)

YT_TOKEN = os.getenv('YT_TOKEN')
ENABLE_TVM = os.getenv('ENABLE_TVM', 'True') == 'True'
TVM_TOKEN = os.getenv('TVMTOOL_LOCAL_AUTHTOKEN') or os.getenv('TVM_TOKEN')
TVM_NAME = os.getenv('TVM_NAME')
BLACKBOX_TVM_NAME = 'ProdYateam' if os.getenv('TVMTOOL_LOCAL_AUTHTOKEN') else 223
TVM_DESTINATIONS = [BLACKBOX_TVM_NAME]

EMAIL_HOST = 'outbound-relay.yandex.net'

AVIA_BACKEND_URL = 'http://backend.unstable.avia.yandex.net'

if YANDEX_ENVIRONMENT_TYPE == EnvironmentType.PRODUCTION:
    SEND_PARTNER_STAT_EMAIL_BCC = 'avia-partnerstat-copy@yandex-team.ru'
    RASP_REST_HOST = 'https://int-api.rasp.yandex.net'
    DEBUG = False
    ENABLE_TOPIC_LOG = True
    ENABLE_YT_DELIVERY = True
    AVIA_BACKEND_URL = 'http://backend.production.avia.yandex.net'

elif YANDEX_ENVIRONMENT_TYPE == EnvironmentType.TESTING:
    AVIA_ADMIN_HOST = 'admin.avia.tst.yandex-team.ru'
    SEND_PARTNER_STAT_EMAIL_BCC = 'avia-partnerstat-copy-test@yandex-team.ru'
    RASP_REST_HOST = 'https://int-api.tst.rasp.yandex.net'
    AVIA_BACKEND_URL = 'http://backend.testing.avia.yandex.net'

YANDEX_TEAM_BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'

AVIA_IMPORT_USER_AUTH = {
    'avia-admin-robot': os.getenv('AVIA_IMPORT_AUTH'),
}

RAVEN_CONFIG = {
    'dsn': os.getenv('SENTRY_DSN'),
}

YT_TMP_DIRECTORY = '//home/avia/tmp'
TOP_DIRECTIONS_TMP_PATH = YT_TMP_DIRECTORY

IDM_URL_PREFIX = 'dostup'
IDM_API_TVM_SETTINGS = {
    'client_id': TVM_NAME,
    'secret': TVM_TOKEN,
}

patch_settings_for_arcadia()
