# -*- encoding: utf-8 -*-
import logging

from blackbox import XmlBlackbox, FIELD_LOGIN

from django.conf import settings
from django.contrib.auth import login
from django.contrib.auth.admin import User
from django.contrib.auth.models import AnonymousUser
from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.library.python.tvm_ticket_provider import provider_fabric

log = logging.getLogger(__name__)


blackbox = XmlBlackbox(
    url=settings.YANDEX_TEAM_BLACKBOX_URL,
    dbfields=[FIELD_LOGIN],
)


client = provider_fabric.create(settings)


class Auth:
    def process_request(self, request):
        if request.path.startswith(settings.AUTH_EXCLUDE_PATHS):
            return

        if isinstance(request.user, AnonymousUser):
            ya_login = self.get_yauser_login(request)

            if not ya_login:
                passport_url = 'https://passport.yandex-team.ru/auth?%s' % (
                    urlencode({'retpath': request.build_absolute_uri()})
                )
                return HttpResponseRedirect(passport_url)

            try:
                django_user, _created = User.objects.get_or_create(
                    username=ya_login,
                    email='%s@yandex-team.ru' % ya_login
                )

            except Exception:
                log.error('get_or_create_django_user: %r', ya_login)
                raise

            # https://docs.djangoproject.com/en/1.8/topics/auth/default/#django.contrib.auth.login
            django_user.backend = 'django.contrib.auth.backends.ModelBackend'
            login(request, django_user)

        else:
            django_user = request.user

        if not (django_user.is_staff or django_user.is_superuser):
            return HttpResponseRedirect('/need_approve/')

    def get_yauser_login(self, request):
        sessionid = request.COOKIES.get('Session_id')

        userip = request.META.get('REMOTE_ADDR') or request.META.get('HTTP_X_REAL_IP')
        host = request.META.get('HTTP_HOST')

        if sessionid is None:
            return None

        headers = None
        ticket = client.get_ticket(settings.BLACKBOX_TVM_NAME)
        if ticket:
            headers = {'X-Ya-Service-Ticket': ticket}

        session = blackbox.sessionid(
            sessionid=sessionid,
            userip=userip,
            host=host,
            headers=headers,
        )

        return session['fields']['login']
