# -*- encoding: utf-8 -*-
from django import forms
from django.conf.urls import url, include
from django.core import serializers as model_serializers
from rest_framework import routers, serializers, viewsets, status
from rest_framework.decorators import api_view, permission_classes
from rest_framework.permissions import IsAuthenticated, DjangoModelPermissions
from rest_framework.response import Response

from travel.avia.stat_admin.data.models import PartnerReview, ScreenShot


# Serializers define the rest API representation.
class PartnerReviewSerializer(serializers.ModelSerializer):
    class Meta:
        model = PartnerReview
        fields = (
            'id',
            'partner',
            'result',
            'description',
            'hit_time',
            'review_time',
            'point_from',
            'point_to',
            'date_forward',
            'date_backward',
            'klass',
            'adults',
            'children',
            'infants',
            'national_version',
            'price_value',
            'price_currency',
            'price_unixtime',
            'price_diff_abs',
            'price_diff_rel',
            'price_revise',
            'shown_price_value',
            'shown_price_currency',
            'shown_price_unixtime',
            'shown_result',
            'shown_price_diff_abs',
            'shown_price_diff_rel',
            'order_content',
            'revise_data',
            'redirect_params',
            'user_info',
            'query_source',
            'utm_source',
            'utm_campaign',
            'utm_medium',
            'utm_content',
            'wizard_redir_key',
            'wizard_flags',
            'marker',
        )


# ViewSets define the view behavior.
class PartnerReviewViewSet(viewsets.ModelViewSet):
    queryset = PartnerReview.objects.all()
    serializer_class = PartnerReviewSerializer

    permission_classes = [
        DjangoModelPermissions,
        IsAuthenticated,
    ]


class ScreenshorForm(forms.Form):
    partner_review_id = forms.IntegerField(label=u'сохранненый Id проверки', min_value=1)
    screenshot = forms.CharField(label=u'PNG-Скриншот в base64')
    idx = forms.IntegerField(label=u'Номер скриншота в последовательности', min_value=1)


@api_view(['POST'])
@permission_classes((IsAuthenticated,))
def partner_review_screenshots(request):
    form = ScreenshorForm(request.data)
    if not form.is_valid():
        return Response(form.errors, status=status.HTTP_400_BAD_REQUEST)

    partner_review_id = form.cleaned_data['partner_review_id']
    screenshot = form.cleaned_data['screenshot']
    idx = form.cleaned_data['idx']

    s = ScreenShot.create(screenshot, partner_review_id, idx)
    s.save()

    return Response(model_serializers.serialize('json', [s, ]), status=status.HTTP_201_CREATED)


# Routers provide an easy way of automatically determining the URL conf.
router = routers.DefaultRouter()
router.register(r'partner_reviews', PartnerReviewViewSet)
router.register(r'partner-review', PartnerReviewViewSet)


urlpatterns = [
    url(r'^', include(router.urls)),
    url(r'^rest-auth/', include('rest_framework.urls', namespace='rest_framework')),
    url(r'partner-review-screenshots', partner_review_screenshots, name='partner_review_screenshots')
]
