# -*- encoding: utf-8 -*-
import os
import sys

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
import django
django.setup()

from datetime import date
from lxml import etree
from optparse import OptionParser

from travel.avia.stat_admin.data.models import UTM, UTM_incoming, UTM_redirect


AVIA_CLICK_PRICE = 23  # с НДС


def get_source(source):
    if os.path.isfile(source):
        return [source]

    elif os.path.isdir(source):
        return sorted([os.path.join(source, f) for f in os.listdir(source) if os.path.isfile(os.path.join(source, f))])


def get_content_from_file(file_name):
    if os.path.isfile(file_name):
        f = open(file_name, 'r')
        return f.read()


def parce_rus_date(report_date):
    day, month, year = report_date.encode('utf-8').replace('г.', '').replace('.', '').strip().split(' ')
    months = ['янв', 'фев', 'мар', 'апр', 'май', 'июн',
              'июл', 'авг', 'сен', 'окт', 'нояб', 'дек']

    parsed_date = date(
        int(year),
        months.index(month) + 1,
        int(day)
    )

    return parsed_date


def parse_xml(xml_content):
    tree = etree.fromstring(xml_content)
    date_range_xpath = tree.xpath('//report/date-range')

    if not date_range_xpath:
        sys.exit()

    for date_range in date_range_xpath:
        report_date = date_range.get('date')

    report_date = parce_rus_date(report_date)

    for row in tree.xpath('//report/table/row'):
        campaign = row.get('campaign')
        try:
            avg_cost = float(row.get('avgCost').replace(u'на клик', '').strip().replace(',', '.'))

        except ValueError:
            avg_cost = 0

        yield {
            'campaign': campaign,
            'avg_cost': avg_cost,
            'report_date': report_date
        }


def save_campaign_prices(campaigns_iter):
    for campaign in campaigns_iter:
        utms = UTM.objects.filter(source='google', campaign=campaign['campaign'])
        UTM_incoming.objects.filter(utm__in=utms, eventdate=campaign['report_date']).update(price=campaign['avg_cost'])
        UTM_redirect.objects.filter(utm__in=utms, eventdate=campaign['report_date']).update(price=AVIA_CLICK_PRICE)


def main():
    optparser = OptionParser()

    optparser.add_option("-s", "--source", dest="source")

    options, args = optparser.parse_args()

    file_names = get_source(options.source)

    for file_name in file_names:
        xml_content = get_content_from_file(file_name)
        campaigns_iter = parse_xml(xml_content)
        save_campaign_prices(campaigns_iter)


if __name__ == '__main__':
    main()
