import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
import django
django.setup()

import argparse
import logging
from datetime import datetime, timedelta

import pytz
from django.db.models import Min

from travel.avia.stat_admin.data.models import OhmIncoming
from travel.avia.stat_admin.lib.logs import add_stdout_handler, create_current_file_run_log


OHM_LIFETIME = timedelta(days=366)
STEP = timedelta(hours=6)


logger = logging.getLogger(__name__)


def verbose_delete(right_border, logger):
    logger.info('Delete to %s', right_border.strftime('%Y-%m-%dT%H:%M:%S'))
    result = OhmIncoming.objects.filter(eventdatetime__lt=right_border).delete()
    if result is None:
        logger.info('Nothing to delete')
    else:
        logger.info('Deleted: %d', result[0])


def main():
    create_current_file_run_log()

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true', dest='verbose')
    args = parser.parse_args()

    if args.verbose:
        add_stdout_handler(logger)

    try:
        logger.info('Start')
        today = pytz.timezone('Europe/Moscow').localize(datetime.now())
        min_eventdatetime = OhmIncoming.objects.all().aggregate(min=Min('eventdatetime'))['min']
        logger.info('Minimum eventdatetime: %s', min_eventdatetime.strftime('%Y-%m-%dT%H:%M:%S'))

        right_border = today - OHM_LIFETIME
        current_right_border = min_eventdatetime + STEP
        while current_right_border <= right_border:
            verbose_delete(min(current_right_border, right_border), logger)
            current_right_border += STEP

        verbose_delete(right_border, logger)
        logger.info('End')
    except:
        logger.exception('ERROR')
        raise


if __name__ == '__main__':
    main()
