import os
from datetime import datetime, timedelta

REVIEW_LIFETIME = timedelta(days=90)


def main():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
    import django
    django.setup()

    from travel.avia.stat_admin.data.models import PartnerReview

    today = datetime.now()
    PartnerReview.objects.filter(review_time__lt=today - REVIEW_LIFETIME).delete()


if __name__ == '__main__':
    main()
