# -*- encoding: utf-8 -*-
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
import django
django.setup()

import re
import logging
import requests

from datetime import datetime, timedelta
from optparse import OptionParser

from django.db.models import Count

from travel.avia.stat_admin.data.models.main import UserGoalStat, OhmRedirect

CLICK_HOUSE_URL_TEMPLATE = 'http://mtstat.yandex.ru:8123/?query={query}&user={user}&password={password}'
CLICKHOUSE_USER = 'avia'
CLICKHOUSE_PASSWORD = 'QFwsalZM'

SQL_TEMPLATE = """SELECT
    UserID,
    COUNT(*) AS cnt,
    dictGetString('UserAgent', 'value', toUInt64(UserAgent)) AS UserAgentName
FROM hits_all
WHERE (EventDate = '{event_date}') AND (CounterID = 13979182) AND has(GoalsReached, 12787481) AND (UserID GLOBAL IN
(
    SELECT UserID
    FROM hits_all
    WHERE (EventDate = '{event_date}') AND (CounterID = 13979182)
))
GROUP BY
    UserID,
    UserAgentName
"""


def compact_sql(sql):
    return re.sub(r'\s+', ' ', sql)


def main():
    optparser = OptionParser()

    log = logging.getLogger(__name__)
    optparser.add_option("-d", "--days", dest="days", type="int", default=2)
    options, args = optparser.parse_args()

    log.info('Start')

    today = datetime.now().date()

    for x in range(options.days):
        report_date = today - timedelta(days=x)
        log.info('Cache redirects: %s', report_date.strftime('%Y-%m-%d'))
        avia_cache = {}
        for r in OhmRedirect.objects.filter(eventdate=report_date).values('yandexuid').annotate(count=Count('yandexuid')):
            try:
                uid = int(r['yandexuid'])
            except ValueError:
                continue

            avia_cache[uid] = r['count']

        log.info('Delete %s', report_date.strftime('%Y-%m-%d'))
        UserGoalStat.objects.filter(eventdate=report_date).delete()

        log.info('Process %s', report_date.strftime('%Y-%m-%d'))
        sql = compact_sql(SQL_TEMPLATE.format(event_date=report_date.strftime('%Y-%m-%d')))
        url = CLICK_HOUSE_URL_TEMPLATE.format(
            query=sql,
            user=CLICKHOUSE_USER,
            password=CLICKHOUSE_PASSWORD,
        )

        r = requests.get(url, timeout=360)

        lines = r.content.strip().split('\n')

        goals_cnt = 0
        for line in lines:
            try:
                uid, coal_count, user_agent = line.split('\t')
            except ValueError:
                log.info('Bad line: %s', line)
                continue

            try:
                uid = int(uid)
            except ValueError:
                log.info('Bad UID: ', uid)
                continue

            goal = UserGoalStat(
                eventdate=report_date,
                yandexuid=uid,
                user_agent=user_agent.strip(),
                goals_count=int(coal_count.strip()),
                avia_count=avia_cache.get(int(uid), 0),
            )

            goal.save()
            goals_cnt += 1

        log.info('%s records saved', goals_cnt)

    log.info('Done')


if __name__ == '__main__':

    main()
