# -*- coding: utf-8 -*-
import logging
import os
import requests

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
import django
django.setup()

from django.conf import settings
from retrying import retry

from travel.avia.stat_admin.data.models.partner import PartnerCode

log = logging.getLogger(__name__)


@retry(
    stop_max_attempt_number=3,
    wait_exponential_multiplier=100,
    wait_exponential_max=500
)
def get_partners_data():
    response = requests.post(
        settings.AVIA_BACKEND_URL,
        json=[{
            "name": "partnersData",
        }],
    )
    response.raise_for_status()
    return response.json()


def main():
    log.info('Start')

    partners_data = get_partners_data()

    for p in partners_data['data'][0]:
        partner_code = p['code']
        _, created = PartnerCode.objects.get_or_create(code=partner_code)

        if created:
            log.info('Created new partner code: %s', partner_code)

    log.info('End')


if __name__ == '__main__':
    main()
