# -*- coding: utf-8 -*-
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.stat_admin.local_settings')
import django
django.setup()

import subprocess
import sys

from django.conf import settings
from django.core.mail.message import EmailMultiAlternatives

CRON_MAIL = ['avia-cron@yandex-team.ru']

if __name__ == '__main__':
    args = ' '.join(sys.argv[1:])

    cmd = ['bash', '-c', args]

    try:
        cmnd_output = subprocess.check_output(cmd, stderr=subprocess.STDOUT)

    except subprocess.CalledProcessError as exc:
        subject = 'Script execution failed %s' % args
        body = args

        if exc.returncode:
            body += '\nreturn code: %s' % exc.returncode

        if exc.output:
            body += '\n\n%s' % exc.output

        mail = EmailMultiAlternatives(
            subject=subject,
            body=body,
            from_email=settings.SERVER_EMAIL,
            to=CRON_MAIL,
        )
        mail.send()

    sys.exit(0)
