# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from django import template

log = logging.getLogger(__name__)

register = template.Library()


@register.filter
def format_int(val):
    return '{:,}'.format(int(val)).replace(',', ' ')


def test_format_int():
    assert format_int(12345678) == '12 345 678'


@register.simple_tag()
def pluralise(n, f1, f234, f567890):
    """https://ru.wikipedia.org/wiki/Gettext#cite_ref-4"""
    return (f1 if (n % 10 == 1 and n % 100 != 11) else
            f234 if 2 <= n % 10 <= 4 and (n % 100 < 10 or n % 100 >= 20) else f567890)


def test_pluralise():
    forms = ['яблоко', 'яблока', 'яблок']
    assert pluralise(0, *forms) == 'яблок'
    assert pluralise(1, *forms) == 'яблоко'
    assert pluralise(2, *forms) == 'яблока'
    assert pluralise(3, *forms) == 'яблока'
    assert pluralise(4, *forms) == 'яблока'
    assert pluralise(5, *forms) == 'яблок'
    assert pluralise(6, *forms) == 'яблок'
    assert pluralise(7, *forms) == 'яблок'
    assert pluralise(8, *forms) == 'яблок'
    assert pluralise(9, *forms) == 'яблок'
    assert pluralise(10, *forms) == 'яблок'
    assert pluralise(11, *forms) == 'яблок'
    assert pluralise(13, *forms) == 'яблок'
    assert pluralise(21, *forms) == 'яблоко'
