# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import os


class EnvironmentType(object):
    DEVELOPMENT = 'development'
    PRODUCTION = 'production'
    TESTING = 'testing'

    @classmethod
    def verify(cls, env):
        if env not in (cls.DEVELOPMENT, cls.PRODUCTION, cls.TESTING):
            raise NotImplementedError('Unsupported environment type "{}"'.format(env))


YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE')
EnvironmentType.verify(YANDEX_ENVIRONMENT_TYPE)
