import os

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin

from data import views
from travel.avia.stat_admin.data.imports import airport, settlement
from travel.avia.stat_admin.settings.environment import EnvironmentType

admin.autodiscover()

urlpatterns = [
    url(r'^{}/'.format(settings.IDM_URL_PREFIX), include('django_idm_api.urls')),
    url(r'^need_approve/', views.need_approve_page),
    url(r'^search/$', views.search, name='search'),
    url(r'^redir/$', views.redirects, name='redirects'),
    url(r'^jobs/$', views.jobs, name='jobs'),
    url(r'^jobs/(?P<job_id>[\d]+)/$', views.job_download, name='job_download'),
    url(r'^cohorts/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts, name='cohorts'),
    url(r'^compare_metrika_and_we/(?P<eventdate>[\d\-]+)/$', views.compare_metrika_and_we, name='compare_metrika_and_we'),
    url(r'^compare_metrika_and_we/(?P<eventdate>[\d\-]+)/(?P<yandexuid>[\d]+)/$', views.compare_metrika_and_we_detailed, name='compare_metrika_and_we_detailed'),
    url(r'^cohorts/v3/csv/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts_v3_csv, name='cohorts_v3_csv'),
    url(r'^cohorts/v3/json/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts_v3_json, name='cohorts_v3_json'),
    url(r'^cohorts/v3/csv/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/(?P<whence>[\w]+)/$', views.cohorts_v3_csv, name='cohorts_v3_csv'),
    url(r'^cohorts/v3/json/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/(?P<whence>[\w]+)/$', views.cohorts_v3_json, name='cohorts_v3_json'),
    url(r'^cohorts/v3/decoded/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts_v3_decoded, name='cohorts_v3_decoded'),
    url(r'^cohorts/v4/json/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts_v4_json, name='cohorts_v4_json'),
    url(r'^cohorts/v5/json/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/$', views.cohorts_v5_json, name='cohorts_v5_json'),
    url(r'^cohorts/v5/json/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/(?P<whence>[\w]+)/$', views.cohorts_v5_json, name='cohorts_v5_json'),
    url(r'^cohorts/v5/csv/(?P<eventdate>[\d\-]+)/(?P<cohorts_num>[\d]+)/(?P<whence>[\w]+)/$', views.cohorts_v5_csv, name='cohorts_v5_csv'),
    url(r'^online/errors/$', views.errors, name='errors'),
    url(r'^online/rivals/$', views.rivals, name='errors'),
    url(r'^online/searches/$', views.searches, name='searches'),
    url(r'^online/flexiblecache/$', views.flexiblecache_table_view, name='searches'),
    url(r'^online/dynamiccache/$', views.dynamiccache_table_view, name='searches'),
    url(r'^online/visitors/$', views.visitors, name='visitors'),
    url(r'^online/cohort/$', views.cohort, name='cohort'),
    url(r'^online/lost/$', views.lost_goals, name='lost_goals'),
    url(r'^online/lost/raw/(?P<eventdate>[\d\-]+)/$', views.lost_raw, name='lost_raw'),
    url(r'^online/lost/(?P<yandex_uid>[\d]+)/(?P<left_date>[\d\-]+)/(?P<right_date>[\d\-]+)/$', views.lost_goals_details, name='lost_goals_details'),
    url(r'^online/cohort/upload/$', views.connector_upload, name='connector_upload'),
    url(r'^online/map/clicks/$', views.clicks),
    url(r'^online/partner/queries/$', views.partner_queries),
    url(r'^online/daemon/$', views.daemon, name='daemon'),
    url(r'^import/settlements/$', settlement.import_avia_settlements, name='import_settlements'),
    url(r'^import/airports/$', airport.import_avia_airports, name='import_airports'),
    url(r'^reports/top100/$', views.top_positions),
    url(r'^reports/partners/$', views.partners),
    url(r'^reports/partners/returnings/$', views.returnings),
    url(r'^reports/partners/redirects/$', views.partner_redirects),
    url(r'^reports/partners/query_time/$', views.partner_query_time),
    url(r'^version$', views.version),
    url(r'^ping$', views.ping),
    url(r'^$', views.index, name='index'),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^rest/', include('travel.avia.stat_admin.rest.urls')),
]

if settings.YANDEX_ENVIRONMENT_TYPE == EnvironmentType.DEVELOPMENT and os.getenv('ENABLE_DEV_STATIC'):
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
