# -*- coding: utf-8 -*-
from datetime import datetime, timedelta


def parse_qid(qid, lang=None, t_code=None):
    try:
        # Если распарсится новый формат, то параметры lang, t_code затрутся
        when_created_raw, service, t_code, qkey, lang = qid.split('.')
    except ValueError:
        when_created_raw, service, qkey = qid.split(':')
    when_created = _parse_when_created(when_created_raw)
    return when_created, service, t_code, qkey, lang


def _parse_when_created(raw):
    ymd, hms, mils = raw.split('-')
    return datetime.strptime(ymd + 'T' + hms, '%y%m%dT%H%M%S') + timedelta(milliseconds=int(mils))
