"""
WSGI config for stats project.

This module contains the WSGI application used by Django's development server
and any production WSGI deployments. It should expose a module-level variable
named ``application``. Django's ``runserver`` and ``runfcgi`` commands discover
this application via the ``WSGI_APPLICATION`` setting.

Usually you will have the standard Django WSGI application here, but it also
might make sense to replace the whole Django WSGI application with a custom one
that later delegates to the Django one. For example, you could introduce WSGI
middleware here, or combine a Django application with an application of another
framework.

"""

# This application object is used by any WSGI server configured to use this
# file. This includes Django's development server, if the WSGI_APPLICATION
# setting points here.
from django.core.wsgi import get_wsgi_application
from django.conf import settings
from raven.contrib.django.raven_compat.middleware.wsgi import Sentry

application = get_wsgi_application()

if getattr(settings, 'RAVEN_CONFIG', False):
    application = Sentry(application)


# Apply WSGI middleware here.
# from helloworld.wsgi import HelloWorldApplication
# application = HelloWorldApplication(application)

if settings.DEBUG:
    try:
        from werkzeug.debug import DebuggedApplication

        settings.DEBUG_PROPAGATE_EXCEPTIONS = True

        application = DebuggedApplication(application, evalex=True)
    except ImportError:
        pass
