PY2_LIBRARY(stat-admin)

OWNER(g:avia)

PEERDIR(
    contrib/python/cachetools
    contrib/python/pytz

    library/python/blackbox
    library/python/django
    library/python/django-idm-api
    library/python/gunicorn
    library/python/ylog
    yt/python/client
    yt/python/yt/tools
    yt/yt/python/yt_yson_bindings

    travel/library/python/tvm_ticket_provider
    travel/library/python/avia_mdb_replica_info

    contrib/python/Babel
    contrib/python/boto3
    contrib/python/celery
    contrib/python/django-admin-rangefilter
    contrib/python/django-bootstrap3
    contrib/python/django-datetime-widget
    contrib/python/django-filter
    # TODO (simon-ekb): contrib/python/django-grappelli
    contrib/python/django/django-1.11
    contrib/python/djangorestframework
    contrib/python/gunicorn
    contrib/python/ipython
    contrib/python/lxml
    contrib/python/Markdown
    contrib/python/MySQL-python
    contrib/python/dateutil
    contrib/python/raven
    contrib/python/requests
    contrib/python/retrying
    contrib/python/typing
)

PY_SRCS(
    app.py
#    backup/build_dynamic_cache.py
#    conftest.py
    data/__init__.py
    data/admin/__init__.py
    data/admin/main.py
    data/admin/overrides.py
    data/admin/partner.py
    data/admin/partner_review.py
    data/httpresponses.py
    data/imports/__init__.py
    data/imports/airport.py
    data/imports/settlement.py
    data/migrations/0001_initial.py
    data/migrations/0002_auto_20160105_1656.py
    data/migrations/0003_auto_20160108_1240.py
    data/migrations/0004_partnerreview.py
    data/migrations/0005_auto_20160203_1318.py
    data/migrations/0006_auto_20160212_1528.py
    data/migrations/0007_auto_20160316_1624.py
    data/migrations/0008_partner_review_national_version_default.py
    data/migrations/0009_auto_20160325_1354.py
    data/migrations/0010_emailtype_partnercode_partneremail.py
    data/migrations/0011_auto_20160329_0804.py
    data/migrations/0012_partnerquery_avg_query_time.py
    data/migrations/0012_refactoring_partner_emails.py
    data/migrations/0013_rename_eamiltype_to_code.py
    data/migrations/0014_merge.py
    data/migrations/0015_utm_adwords.py
    data/migrations/0016_auto_20160818_1518.py
    data/migrations/0017_auto_20160829_1229.py
    data/migrations/0018_auto_20160829_1827.py
    data/migrations/0019_auto_20160829_1837.py
    data/migrations/0020_auto_20160909_0906.py
    data/migrations/0021_auto_20160909_1308.py
    data/migrations/0022_rivalposition_avia_company.py
    data/migrations/0023_rivalposition_cheaper.py
    data/migrations/0024_auto_20161220_1412.py
    data/migrations/0025_auto_20170117_1425.py
    data/migrations/0026_auto_20170130_1415.py
    data/migrations/0027_goal_stat.py
    data/migrations/0028_setting.py
    data/migrations/0029_partnerreview_search_depth.py
    data/migrations/0030_auto_20170704_1533.py
    data/migrations/0031_utm_query_source.py
    data/migrations/0032_ohm_version.py
    data/migrations/0033_add_indexes.py
    data/migrations/0034_ohm_incoming.py
    data/migrations/0034_settlement.py
    data/migrations/0035_airport.py
    data/migrations/0035_auto_20170824_0900.py
    data/migrations/0036_merge.py
    data/migrations/0037_auto_20171123_1735.py
    data/migrations/0038_partnerreview_wizard_flags.py
    data/migrations/0039_auto_20171204_1353.py
    data/migrations/0040_auto_20180124_0928.py
    data/migrations/0041_auto_20180124_0939.py
    data/migrations/0042_ohmredirect_click_price.py
    data/migrations/0043_auto_20180605_2342.py
    data/migrations/0044_auto_20180724_1350.py
    data/migrations/0045_auto_20180724_1504.py
    data/migrations/0046_partnerreview_marker.py
    data/migrations/0047_archivepartnerquery.py
    data/migrations/0048_auto_20190815_0924.py
    data/migrations/0049_auto_20190815_0951.py
    data/migrations/0050_auto_20190815_1237.py
    data/migrations/0051_auto_20190816_1422.py
    data/migrations/0052_auto_20190816_1430.py
    data/migrations/0053_auto_20200115_1101.py
    data/migrations/0053_screenshot.py
    data/migrations/0054_add_ticket_changes_in_pertner_review.py
    data/migrations/__init__.py
    data/models/__init__.py
    data/models/airport.py
    data/models/main.py
    data/models/partner.py
    data/models/partner_review.py
    data/models/settlement.py
    data/settings.py
    data/tasks.py
    data/templatetags/__init__.py
    data/templatetags/defaultfilters.py
    data/views.py
    gunicorn_conf.py
    job/__init__.py
    job/admin.py
    job/migrations/0001_initial.py
    job/migrations/__init__.py
    job/models.py
    job/views.py
    lib/__init__.py
    lib/adwords_report.py
    lib/avia_importers.py
    lib/basic_auth.py
    lib/debugging.py
    lib/exceptions.py
    lib/fileutils.py
    lib/grouping.py
    lib/jobs.py
    lib/logs.py
    lib/mail.py
    lib/point_key.py
    lib/review_filter.py
    lib/s3_sync.py
    lib/scraper.py
    lib/templates.py
#    lib/tests/__init__.py
#    lib/tests/test_avia_importers.py
#    lib/tests/test_grouping.py
#    lib/tests/test_review_filter.py
#    lib/tests/test_title_index.py
    lib/title_index.py
    lib/yt_helpers.py
    local_settings.py
    middleware/__init__.py
    middleware/auth.py
    rest/__init__.py
    rest/auth.py
    rest/settings.py
    rest/urls.py
    scripts/__init__.py
    scripts/archive_partner_query.py
    scripts/build_flexible_cache.py
    scripts/check_positions.py
    scripts/cohorts/__init__.py
    scripts/cohorts/adwords_import.py
    scripts/cohorts/agency.py
    scripts/cohorts/connector.py
    scripts/cohorts/import_utms.py
    scripts/cohorts_v2/__init__.py
    scripts/cohorts_v2/calc_cohorts.py
    scripts/cohorts_v2/extract_utms.py
    scripts/cohorts_v2/import_utms.py
    scripts/cohorts_v2/make_report.py
    # scripts/cohorts_v2/tests/__init__.py
    # scripts/cohorts_v2/tests/test_cohorts.py
    scripts/cohorts_v3/__init__.py
    scripts/cohorts_v3/import_redirects.py
    scripts/cohorts_v3/import_topics.py
    scripts/data/__init__.py
    scripts/data/scraper_data.py
    scripts/delete_old_ohm_incoming.py
    scripts/delete_old_reviews.py
    scripts/dump_partner_reviews_to_yt.py
    scripts/import_aurora_aviatickets.py
    scripts/import_goals.py
    scripts/import_parner_queries.py
    scripts/import_redirects.py
    scripts/import_redirects_heatmap.py
    scripts/import_searches.py
    scripts/import_servicemetric.py
    scripts/maintenance/__init__.py
    scripts/maintenance/clean_old_jobs.py
    scripts/maintenance/get_partners_codes.py
    scripts/management/__init__.py
    scripts/management/commands/__init__.py
    scripts/management/commands/_loggers.py
    scripts/management/commands/_yt_send_partners_stat.py
    scripts/management/commands/send_partners_stat.py
    scripts/parse_access_log.py
    scripts/partners_requests.py
    scripts/query_time.py
    scripts/redirect.py
    scripts/returning.py
    scripts/run_script.py
    scripts/templatetags/__init__.py
    scripts/templatetags/tools.py
    scripts/top_and_positions.py
#    stat_tester/__init__.py
#    stat_tester/partner_review_fabric.py
    settings/environment.py
#    tester/__init__.py
#    tester/initializer.py
#    tester/plugins.py
#    tester/plugins/__init__.py
#    tester/plugins/transaction.py
#    tester/runner.py
#    tester/testcase.py
#    tester/transaction_context.py
#    tests_settings.py
    urls.py
    utils/__init__.py
    utils/http.py
    utils/logs.py
    utils/mysql_switcher/__init__.py
    utils/mysql_switcher/base.py
    utils/query.py
    wsgi.py
)

RESOURCE_FILES(
    PREFIX travel/avia/stat_admin/
    data/templates/_index.html
    data/templates/_placeholders.html
    data/templates/_progressbar.html
    data/templates/input_filter.html
    data/templates/admin/partnerreview/stat.html
    data/templates/data/cohort.html
    data/templates/data/cohorts_details.html
    data/templates/data/compare_metrika_and_we.html
    data/templates/data/compare_metrika_and_we_detailed.html
    data/templates/data/dynamic_cache.html
    data/templates/data/flexible_cache.html
    data/templates/data/index.html
    data/templates/data/jobs.html
    data/templates/data/lost.html
    data/templates/data/lost_details.html
    data/templates/data/need_approve.html
    data/templates/data/online_click.html
    data/templates/data/online_clicks.html
    data/templates/data/online_errors.html
    data/templates/data/online_searches.html
    data/templates/data/online_visitors.html
    data/templates/data/partner_queri_time.html
    data/templates/data/partner_queries.html
    data/templates/data/partners.html
    data/templates/data/redirects.html
    data/templates/data/report_top100.html
    data/templates/data/returnings.html
    data/templates/data/rivals.html
    data/templates/search.html

    templates/admin/data/partnerreview/change_list.html
)

END()

RECURSE(
    bin
)
