from logging.config import fileConfig

from alembic import context

from travel.avia.subscriptions.app.api.init_db import Database
from travel.avia.subscriptions.app.model.db import Base
# this is the Alembic Config object, which provides
# access to the values within the .ini file in use.
from travel.avia.subscriptions.app.settings.app import AppConfig, get_app_config

config = context.config
app_config: AppConfig = get_app_config()
database_connections_string = Database.format_dsn(app_config)
config.set_main_option(
    'sqlalchemy.url',
    database_connections_string
)

# Interpret the config file for Python logging.
# This line sets up loggers basically.
fileConfig(config.config_file_name)

# for 'autogenerate' support
target_metadata = Base.metadata


def run_migrations_offline():
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option("sqlalchemy.url")
    context.configure(
        url=url,
        target_metadata=target_metadata,
        literal_binds=True,
        compare_server_default=True,
        dialect_opts={"paramstyle": "named"},
    )

    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online():
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """
    with Database(app_config).connection() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
            compare_server_default=True,
        )

        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
