"""basic promo structure

Revision ID: 481d2c1e4d22
Revises: 
Create Date: 2019-09-23 12:29:13.077570+00:00

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.

revision = '481d2c1e4d22'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'email',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('email', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('email')
    )
    op.create_index('email_lower(email)_uindex', 'email', [sa.text('lower(email)')], unique=True)
    op.create_index('emails_email_uindex', 'email', ['email'], unique=True)
    op.create_table(
        'promo_subscription',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('code', sa.String(), nullable=False),
        sa.Column('national_version', sa.String(), nullable=False),
        sa.Column('language', sa.String(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('code', 'national_version', 'language')
    )
    op.create_table(
        'travel_vertical',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('name', sa.String(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('name')
    )
    op.create_table(
        'user_auth_type',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('name', sa.String(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('name')
    )
    op.create_table(
        'user_auth',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('user_auth_type_id', sa.Integer(), nullable=False),
        sa.Column('auth_value', sa.String(), nullable=False),
        sa.ForeignKeyConstraint(['user_auth_type_id'], ['user_auth_type.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('user_auth_type_id', 'auth_value')
    )
    op.create_table(
        'user',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('user_auth_id', sa.Integer(), nullable=False),
        sa.Column('email_id', sa.Integer(), nullable=False),
        sa.Column('approved_at', sa.DateTime(), nullable=True),
        sa.Column('user_timezone', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['email_id'], ['email.id'], ),
        sa.ForeignKeyConstraint(['user_auth_id'], ['user_auth.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('user_auth_id', 'email_id')
    )
    op.create_table(
        'user_promo_subscription',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=False),
        sa.Column('promo_subscription_id', sa.Integer(), nullable=False),
        sa.Column('travel_vertical_id', sa.Integer(), nullable=False),
        sa.Column('source', sa.String(), nullable=False),
        sa.ForeignKeyConstraint(['promo_subscription_id'], ['promo_subscription.id'], ),
        sa.ForeignKeyConstraint(['travel_vertical_id'], ['travel_vertical.id'], ),
        sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('user_id', 'promo_subscription_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_promo_subscription')
    op.drop_table('user')
    op.drop_table('user_auth')
    op.drop_table('user_auth_type')
    op.drop_table('travel_vertical')
    op.drop_table('promo_subscription')
    op.drop_index('emails_email_uindex', table_name='email')
    op.drop_table('email')
    # ### end Alembic commands ###
