"""Added price change subscription tables

Revision ID: 97765cd4feca
Revises: b225f916d4a8
Create Date: 2020-03-24 14:32:20.111951+00:00

"""
from alembic import op
import sqlalchemy as sa

from travel.avia.subscriptions.app.model.db import Json
from travel.avia.subscriptions.app.model.schemas import (
    MinPrice, MinPriceSchema, FilterMinPriceBundle,
    FilterMinPriceBundleSchema, Filter, FilterSchema
)


# revision identifiers, used by Alembic.
revision = '97765cd4feca'
down_revision = 'b225f916d4a8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('price_change_subscription',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('qkey', sa.String(), nullable=False),
    sa.Column('point_from_key', sa.String(), nullable=False),
    sa.Column('point_to_key', sa.String(), nullable=False),
    sa.Column('date_forward', sa.DateTime(), nullable=False),
    sa.Column('date_backward', sa.DateTime(), nullable=True),
    sa.Column('direct_only', sa.Boolean(), nullable=False),
    sa.Column('adults', sa.Integer(), server_default='0', nullable=False),
    sa.Column('children', sa.Integer(), server_default='0', nullable=False),
    sa.Column('infants', sa.Integer(), server_default='0', nullable=False),
    sa.Column('national_version', sa.String(), nullable=False),
    sa.Column('klass', sa.String(), nullable=False),
    sa.Column('lang', sa.String(), server_default='ru', nullable=False),
    sa.Column('min_prices', Json(dataclass=MinPrice,schema=MinPriceSchema(many=True)), nullable=False),
    sa.Column('filtered_minprices', Json(dataclass=FilterMinPriceBundle,
                                         schema=FilterMinPriceBundleSchema(many=True)), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_price_change_subscription_qkey'), 'price_change_subscription', ['qkey'], unique=True)
    op.create_table('user_price_change_subscription',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('price_change_subscription_id', sa.Integer(), nullable=False),
    sa.Column('source', sa.String(), nullable=False),
    sa.Column('applied_filters', Json(dataclass=Filter, schema=FilterSchema(many=True)), nullable=False),
    sa.Column('travel_vertical_id', sa.Integer(), nullable=False),
    sa.Column('date_range', sa.Integer(), server_default='1', nullable=True),
    sa.Column('last_seen_min_price', Json(dataclass=MinPrice, schema=MinPriceSchema), nullable=True),
    sa.CheckConstraint('0 < date_range and date_range <= 120'),
    sa.ForeignKeyConstraint(['price_change_subscription_id'], ['price_change_subscription.id'], ),
    sa.ForeignKeyConstraint(['travel_vertical_id'], ['travel_vertical.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('user_id', 'price_change_subscription_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_price_change_subscription')
    op.drop_index(op.f('ix_price_change_subscription_qkey'), table_name='price_change_subscription')
    op.drop_table('price_change_subscription')
    # ### end Alembic commands ###
