"""Move lang from price subscription to user price subscription

Revision ID: 3a25fcba6b6a
Revises: c2a80693adbf
Create Date: 2020-04-10 03:50:55.866296+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3a25fcba6b6a'
down_revision = 'c2a80693adbf'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('price_change_subscription', 'lang')
    op.add_column('user_price_change_subscription', sa.Column('lang', sa.String(), server_default='ru', nullable=False))
    op.drop_constraint('user_price_change_subscriptio_user_id_price_change_subscrip_key', 'user_price_change_subscription', type_='unique')
    op.create_unique_constraint(None, 'user_price_change_subscription', ['user_id', 'price_change_subscription_id', 'lang'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'user_price_change_subscription', type_='unique')
    op.create_unique_constraint('user_price_change_subscriptio_user_id_price_change_subscrip_key', 'user_price_change_subscription', ['user_id', 'price_change_subscription_id'])
    op.drop_column('user_price_change_subscription', 'lang')
    op.add_column('price_change_subscription', sa.Column('lang', sa.VARCHAR(), server_default=sa.text("'ru'::character varying"), autoincrement=False, nullable=False))
    # ### end Alembic commands ###
