# coding=utf-8
from __future__ import unicode_literals


class InvalidPromoSubscription(ValueError):
    pass


class InvalidPriceChangeSubscription(ValueError):
    def __init__(self, reason, *args, **kwargs):
        self.reason = reason
        super().__init__(self, *args, **kwargs)

    def __str__(self):
        return f'Invalid price change subscription: {self.reason}'


class InvalidTravelVertical(ValueError):
    pass


class InvalidUserAuthType(ValueError):
    pass


class InvalidEmail(ValueError):
    pass


class EmailNotFound(ValueError):
    pass


class NoAccess(ValueError):
    pass


class InvalidApprovingToken(ValueError):
    pass


class UserAlreadyApproved(ValueError):
    pass


class UnknownPointsError(ValueError):
    pass
