from aiohttp.web_exceptions import HTTPBadRequest
from aiohttp.web_response import json_response
from aiohttp_apispec import docs, request_schema
from marshmallow import Schema, fields

from travel.avia.subscriptions.app.api.app import App
from travel.avia.subscriptions.app.api.exceptions import (
    InvalidEmail, InvalidPromoSubscription, InvalidTravelVertical,
    InvalidUserAuthType
)
from travel.avia.subscriptions.app.api.schemas import CredentialsField


class UserSubscriptionListPostRequestSchema(Schema):
    source = fields.Str(example='wizard')
    language = fields.Str(example='en')
    credentials = CredentialsField


def get_user_subscription_list_handler(app: App):
    @docs(
        tags=['user_subscription'],
        summary='Get a list of user subscriptions',
        description='Get a list of user subscriptions, '
                    'identified by credentials (session, passport, iCookie).',
        responses={
            200: {'description': 'Returns an object whose key is mail,'
                                 ' and the value is a list of objects'
                                 ' that describe the subscription'
                                 '(subscription type, code, name, link)'}
        }
    )
    @request_schema(UserSubscriptionListPostRequestSchema)
    async def post(request):
        data = request['data']
        try:
            result = await app.user_subscription_list_actor.list(**data)
            return json_response(result)
        except (InvalidPromoSubscription, InvalidTravelVertical, InvalidUserAuthType, InvalidEmail) as e:
            return HTTPBadRequest(text='{}'.format(e))

    return post
