import csv
import io

from aiohttp import web
from aiohttp_apispec import docs

from travel.avia.subscriptions.app.api.app import App


def get_user_token_handler(app: App):
    chunk_size = 512 * 1024

    @docs(
        tags=['user_token'],
        summary='Return list of tokens',
        description='Returns list of users tokens to get active subscriptions',
        produces=['text/csv'],
        responses={
            200: {'description': 'Returns csv file with all emails and its tokens'}
        }
    )
    async def get(request):
        resp = web.StreamResponse(
            status=200,
            reason='OK',
            headers={'Content-Type': 'text/csv'},
        )
        csv_body = io.StringIO()
        writer = csv.writer(csv_body)

        async for row in app.user_token_actor.get():
            writer.writerow(row)

        csv_body.seek(0)
        await resp.prepare(request)
        while True:
            chunk = csv_body.read(chunk_size)
            if chunk == '':
                break
            await resp.write(chunk.encode())

        await resp.write_eof()

        return resp

    return get
