PY3_LIBRARY()

OWNER(g:avia)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/aiohttp-apispec
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/ujson

    travel/avia/subscriptions/app/lib
    travel/avia/subscriptions/app/model
    travel/avia/subscriptions/app/settings

    library/python/blackbox
    library/python/tvm2
)

PY_SRCS(
    __init__.py
    app.py
    consts.py
    exceptions.py
    init_db.py
    schemas.py
    util_db.py
    web.py

    interactor/user_confirm.py
    interactor/user_price_change_subscription.py
    interactor/user_promo_subscription.py
    interactor/user_subscription.py
    interactor/user_subscription_list.py
    interactor/user_token.py

    handler/user_confirm.py
    handler/user_price_change_subscription.py
    handler/user_promo_subscription.py
    handler/user_subscription.py
    handler/user_subscription_list.py
    handler/user_subscription_subscribed.py
    handler/user_token.py
)

END()
