import hashlib

from contextlib import contextmanager

from typing import Callable, AsyncIterable


async def deduplication_async(seq: AsyncIterable, constraint_func: Callable):
    seen = set()
    async for e in seq:
        constraint = constraint_func(e)
        if constraint not in seen:
            seen.add(constraint)
            yield e


def hashed(val: str):
    return hashlib.sha256(val.encode('utf-8')).hexdigest() if val else None


def context_manager(value):
    @contextmanager
    def manager():
        yield value

    return manager
