# coding=utf-8
from enum import Enum


async def validate_schema(data, schema, ignore_extra=False):
    """
    :param dict data: data to validate schema on
    :param dict[dict] schema: declares data structure in format
        dict(&lt;field_name&gt;=dict(type=&lt;field_type&gt;, required=True/False))

    :param bool ignore_extra:
    :raises KeyError: if required key not found in data
    :raises TypeError: if data type doesnt match schema
    :raises ValueError: if extra data is present and ignore_extra is Falsekee
    """
    for k, v in schema.items():
        if v['required'] and k not in data:
            raise KeyError('Schema requires field `%s`' % (k,))
        elif k in data:
            if (
                not v['required'] and data[k] is None
            ) or (
                isinstance(data[k], v['type'])
            ):
                if isinstance(data[k], Enum):
                    data[k] = data[k].value
                continue
            else:
                raise TypeError('Schema requires field `%s` to be %s, but it\'s %s' % (
                    k, v['type'], type(data[k])
                ))
    if ignore_extra is False and set(data.keys()) - set(schema.keys()):
        raise ValueError('Undeclared fields in data %s' % (
            list(set(data.keys()) - set(schema.keys()))
        ))
