# coding=utf-8
from __future__ import unicode_literals

from sqlalchemy import Column, DateTime, ForeignKey, Integer, String, UniqueConstraint, CheckConstraint

from travel.avia.subscriptions.app.model.db._json import Json
from travel.avia.subscriptions.app.model.db.common import Base, DBInstanceMixin
from travel.avia.subscriptions.app.model.schemas import (
    MinPrice, MinPriceSchema, FilterMinPriceBundle,
    FilterMinPriceBundleSchema, Filter, FilterSchema
)


class PriceChangeSubscription(DBInstanceMixin, Base):
    __tablename__ = 'price_change_subscription'
    # https://docs.sqlalchemy.org/en/13/core/constraints.html#indexes
    # Комбинация index=True, unique=True создает уникальный индекс
    qkey = Column('qkey', String, index=True, unique=True, nullable=False)
    point_from_key = Column('point_from_key', String, nullable=False)
    point_to_key = Column('point_to_key', String, nullable=False)
    date_forward = Column('date_forward', DateTime, nullable=False)
    date_backward = Column('date_backward', DateTime, nullable=True)
    adults = Column('adults', Integer, server_default='0', nullable=False)
    children = Column('children', Integer, server_default='0', nullable=False)
    infants = Column('infants', Integer, server_default='0', nullable=False)
    national_version = Column('national_version', String, nullable=False)
    klass = Column('klass', String, nullable=False)
    min_prices = Column(
        'min_prices',
        Json(
            dataclass=MinPrice,
            schema=MinPriceSchema(many=True),
        ),
        default=[], nullable=False
    )
    filtered_minprices = Column(
        'filtered_minprices',
        Json(
            dataclass=FilterMinPriceBundle,
            schema=FilterMinPriceBundleSchema(many=True),
        ),
        default=[], nullable=False
    )


class UserPriceChangeSubscription(DBInstanceMixin, Base):
    __tablename__ = 'user_price_change_subscription'
    __table_args__ = (
        UniqueConstraint('user_id', 'price_change_subscription_id', 'lang'),
        CheckConstraint('0 < date_range and date_range <= 120'),
    )
    user_id = Column('user_id', Integer, ForeignKey('user.id'), nullable=False)
    price_change_subscription_id = Column(
        'price_change_subscription_id',
        Integer, ForeignKey('price_change_subscription.id'),
        nullable=False
    )
    source = Column('source', String, nullable=False)
    lang = Column('lang', String, nullable=False, server_default='ru')
    applied_filters = Column(
        'applied_filters',
        Json(dataclass=Filter, schema=FilterSchema(many=True)),
        default=[], nullable=False
    )
    travel_vertical_id = Column(
        'travel_vertical_id', Integer,
        ForeignKey('travel_vertical.id'), nullable=False
    )
    date_range = Column('date_range', Integer, server_default='1')
    last_seen_min_price = Column(
        'last_seen_min_price',
        Json(dataclass=MinPrice, schema=MinPriceSchema),
        nullable=True
    )
