# coding=utf-8
from __future__ import unicode_literals

from sqlalchemy import Column, ForeignKey, Integer, String, UniqueConstraint

from travel.avia.subscriptions.app.model.db.common import Base, DBInstanceMixin


class PromoSubscription(DBInstanceMixin, Base):
    __tablename__ = 'promo_subscription'
    __table_args__ = (
        UniqueConstraint('code', 'national_version', 'language'),
    )
    code = Column('code', String, nullable=False)
    national_version = Column('national_version', String, nullable=False)
    language = Column('language', String, nullable=False)
    name = Column('name', String, nullable=False, server_default='')
    url = Column('url', String, nullable=False, server_default='')


class TravelVertical(DBInstanceMixin, Base):
    __tablename__ = 'travel_vertical'
    name = Column('name', String, nullable=False, unique=True)


class UserPromoSubscription(DBInstanceMixin, Base):
    __tablename__ = 'user_promo_subscription'
    __table_args__ = (
        UniqueConstraint('user_id', 'promo_subscription_id'),
    )
    user_id = Column('user_id', Integer, ForeignKey('user.id'), nullable=False)
    promo_subscription_id = Column(
        'promo_subscription_id', Integer, ForeignKey('promo_subscription.id'), nullable=False
    )

    travel_vertical_id = Column('travel_vertical_id', Integer, ForeignKey('travel_vertical.id'), nullable=False)
    source = Column('source', String, nullable=False)
