from dataclasses import dataclass
from marshmallow_dataclass import class_schema
from typing import List, Optional


@dataclass
class TransferFilter:
    count: Optional[int] = None
    min_duration: Optional[int] = None
    max_duration: Optional[int] = None
    has_airport_change: Optional[bool] = None
    has_night: Optional[bool] = None


TransferFilterSchema = class_schema(TransferFilter)


@dataclass
class TimeFilter:
    forward_arrival: Optional[int] = None
    forward_departure: Optional[int] = None
    backward_arrival: Optional[int] = None
    backward_departure: Optional[int] = None


TimeFilterSchema = class_schema(TimeFilter)


@dataclass
class AirportFilter:
    forward_departure: Optional[List[int]] = None
    forward_arrival: Optional[List[int]] = None
    forward_transfers: Optional[List[int]] = None
    backward_departure: Optional[List[int]] = None
    backward_arrival: Optional[List[int]] = None
    backward_transfers: Optional[List[int]] = None


AirportFilterSchema = class_schema(AirportFilter)


@dataclass
class Filter:
    with_baggage: Optional[bool] = None
    airlines: Optional[List[int]] = None
    transfer_filters: Optional[TransferFilter] = None
    time_filters: Optional[TimeFilter] = None
    airport_filters: Optional[AirportFilter] = None
    filter_url_postfix: Optional[str] = None


FilterSchema = class_schema(Filter)
