from dataclasses import dataclass, field
from datetime import datetime
from marshmallow import validate
from marshmallow_dataclass import class_schema
from typing import List, Optional

from travel.avia.subscriptions.app.model.schemas.filter import Filter


@dataclass
class MinPrice:
    time: datetime
    value: float
    currency: str = field(metadata={'validate': validate.Length(max=3)})
    variants: Optional[dict] = None


MinPriceSchema = class_schema(MinPrice)


@dataclass
class FilterMinPriceBundle:
    sent_min_price: Optional[MinPrice] = None
    filter: Optional[Filter] = None
    min_prices: Optional[List[MinPrice]] = None


FilterMinPriceBundleSchema = class_schema(FilterMinPriceBundle)
