from typing import Optional
from urllib.parse import urlencode, urljoin

from travel.avia.subscriptions.app.lib.qkey import QkeyStructure
from travel.avia.subscriptions.app.settings.app import frontend_hosts


FRONTEND_HOSTS = frontend_hosts()
FRONTEND_DATE_FMT = '%Y-%m-%d'


def subscriptions_cabinet_link(email_token: str, national_version: str):
    # TODO: обсудить url path и изменить
    return build_link(
        url_path='cabinet',
        args={'token': email_token},
        national_version=national_version
    )


def user_confirm_link(approving_token: str, national_version: str):
    # TODO: обсудить url path и изменить
    return build_link(
        url_path='confirm',
        args={'approving_token': approving_token},
        national_version=national_version
    )


def avia_search_link(
    qkey_struct: QkeyStructure,
    language: str,
    utm: Optional[dict] = None,
    filter_fragment: Optional[str] = None
):
    if filter_fragment is None:
        filter_fragment = ''

    # TODO: для fromBlock значение точно должно быть emailAlert
    params = {
        'fromBlock': 'emailAlert',
        'fromId': qkey_struct.point_from_key,
        'toId': qkey_struct.point_to_key,
        'when': qkey_struct.date_forward.strftime(FRONTEND_DATE_FMT),
        'return_date': qkey_struct.date_backward.strftime(FRONTEND_DATE_FMT) if qkey_struct.date_backward else '',
        'adult_seats': qkey_struct.adults,
        'children_seats': qkey_struct.children,
        'infant_seats': qkey_struct.infants,
        'klass': qkey_struct.klass,
        'lang': language,
    }
    if utm is not None:
        params.update(utm)

    link = build_link(
        url_path='search',
        args=params,
        national_version=qkey_struct.national_version
    )
    return link + filter_fragment


def build_link(*, url_path: str, args: dict, national_version: Optional[str] = None):
    host = FRONTEND_HOSTS.get(national_version, FRONTEND_HOSTS['ru'])
    url = urljoin(host, url_path)
    args = urlencode(args)

    return f'{url}?{args}'
