package main

var (
	SettlementType = 0
	StationType    = 1
	CountryType    = 2
	UnknownType    = -1
)

type Region struct {
	id          int
	title       string
	titleByLang map[string]string
}

type Country struct {
	id          int
	title       string
	titleByLang map[string]string
	code        string
}

type Point struct {
	pointKey             string
	countryID            int
	regionID             int
	title                string
	titleByLang          map[string]string
	hidden               bool // Объект скрыт или все его аэропорты скрыты
	haveAirport          bool // В городе есть аэропорт. Для станций и стран полагаем равным true
	haveNotHiddenAirport bool
}

func (p Point) Title(lang string) string {
	title, ok := p.titleByLang[lang]

	if !ok || title == "" {
		switch lang {
		case "tr":
			title = p.titleByLang["en"]
		case "uk":
			title = p.titleByLang["ru"]
		case "de":
			title = p.titleByLang["en"]
		}
		if title == "" {
			title = p.title
		}
	}

	return title
}

func (c Country) Title(lang string) string {
	title, ok := c.titleByLang[lang]

	if !ok || title == "" {
		switch lang {
		case "tr":
			title = c.titleByLang["en"]
		case "uk":
			title = c.titleByLang["ru"]
		case "de":
			title = c.titleByLang["en"]
		}
		if title == "" {
			title = c.title
		}
	}

	return title
}

func (r Region) Title(lang string) string {
	title, ok := r.titleByLang[lang]

	if !ok || title == "" {
		switch lang {
		case "tr":
			title = r.titleByLang["en"]
		case "uk":
			title = r.titleByLang["ru"]
		case "de":
			title = r.titleByLang["en"]
		}
		if title == "" {
			title = r.title
		}
	}

	return title
}

func getPointType(pointKey string) int {
	if len(pointKey) == 0 {
		return UnknownType
	}
	switch pointKey[0] {
	case byte('s'):
		return StationType
	case byte('c'):
		return SettlementType
	case byte('l'):
		return CountryType
	}
	return UnknownType
}
