package logging

import (
	"fmt"

	arclog "a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
)

type Logging struct {
	AppLogPath string `config:"AVIA_LOG_PATH,backend=env,required"`
	YTLogPath  string `config:"AVIA_YT_LOG_PATH,backend=env,required"`
	SentryDSN  string `config:"SENTRY_URL,backend=env"`
}

func NewApplicationLogger(loggingSettings *Logging) (*arczap.Logger, error) {
	logger, err := aviaLogging.NewLogger(
		&aviaLogging.Config{
			Level:               arclog.InfoLevel,
			StdoutLoggingConfig: &aviaLogging.StdoutLoggingConfig{},
			FileLoggingConfig: &aviaLogging.FileLoggingConfig{
				FilePath:  loggingSettings.AppLogPath,
				LogFormat: aviaLogging.JSON,
			},
			SentryLoggingConfig: &aviaLogging.SentryLoggingConfig{DSN: loggingSettings.SentryDSN},
		},
	)
	if err != nil {
		return nil, fmt.Errorf("couldn't create application logger. Error: %+v", err)
	}
	return logger, nil
}
