package main

import (
	"strings"
)

func findRune(src []rune, c rune) int {
	for i := range src {
		if src[i] == c {
			return i
		}
	}
	return -1
}

func puntoSwitch(str string, langFrom string, langTo string) (string, bool) {
	// TODO: посмотреть https://golang.org/pkg/strings/#Map
	puntoChars := map[string][]rune{
		"en": []rune("qwertyuiop{[}]asdfghjkl:;'\"zxcvbnm<,>.`"),
		"ru": []rune("йцукенгшщзххъъфывапролджжээячсмитьббююё"),
		"uk": []rune("йцукенгшщзххїїфівапролджжєєячсмитьббююё"),
	}
	puntedStr := ""

	str = strings.ToLower(str)

	fromMap, ok := puntoChars[langFrom]
	if !ok {
		return puntedStr, false
	}

	toMap, ok := puntoChars[langTo]
	if !ok {
		return puntedStr, false
	}

	for _, char := range str {
		runeIndex := findRune(fromMap, char)
		if runeIndex >= 0 {
			puntedStr = puntedStr + string(toMap[runeIndex])
		} else {
			puntedStr = puntedStr + string(char)
		}
	}

	return puntedStr, true
}

func Transliterate(str string, langFrom string, langTo string) (string, bool) {
	ruEnTable := map[string]string{
		"а": "a", "б": "b", "в": "v", "г": "g", "д": "d", "е": "e",
		"ж": "zh", "з": "z", "и": "i", "й": "j", "к": "k", "л": "l",
		"м": "m", "н": "n", "о": "o", "п": "p", "р": "r", "с": "s",
		"т": "t", "у": "u", "ф": "f", "х": "x", "ц": "cz", "ч": "ch",
		"ш": "sh", "щ": "shh", "ъ": "qd", "ы": "qi", "ь": "qt", "э": "ye",
		"ю": "yu", "я": "ya", "ё": "yo",
	}

	enRuTable := map[string]string{
		"a": "а", "b": "б", "c": "ц", "d": "д", "e": "е", "f": "ф",
		"g": "г", "h": "х", "i": "и", "j": "й", "k": "к", "l": "л",
		"m": "м", "n": "н", "o": "о", "p": "п", "q": "я", "r": "р",
		"s": "с", "t": "т", "u": "у", "v": "в", "w": "в", "x": "х",
		"y": "ы", "z": "з",
	}

	transTable := map[string]map[string]string{
		"ru-en": ruEnTable,
		"en-ru": enRuTable,
	}

	transKey := langFrom + "-" + langTo

	tt, ok := transTable[transKey]

	trasliteratedStr := ""

	if ok {
		for _, c := range str {
			tc, ok := tt[string(c)]
			if ok {
				trasliteratedStr = trasliteratedStr + tc
			} else {
				return "", false
			}
		}
	}

	return trasliteratedStr, true
}
