package yt

import (
	"encoding/json"
	"fmt"

	arclog "a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
)

type Logger struct {
	ytFileLogger *arczap.Logger
}

type Record struct {
	NationalVersion  string  `json:"nationalVersion"`
	Lang             string  `json:"lang"`
	Field            string  `json:"field"`
	NeedCountry      bool    `json:"needCountry"`
	ExecutionTime    float32 `json:"executionTime"`
	FromCache        string  `json:"fromCache"`
	Count            int     `json:"count"`
	OtherPoint       string  `json:"otherPoint"`
	OtherQuery       string  `json:"otherQuery"`
	Unixtime         int64   `json:"unixtime"`
	RawQuery         string  `json:"rawQuery"`
	MaxCount         int     `json:"maxCount"`
	OnlyWithAirports bool    `json:"onlyWithAirports"`
}

func (ytLogger *Logger) Close() {
	_ = ytLogger.ytFileLogger.L.Sync()
}

func NewLogger(path string) (logger *Logger, err error) {
	var config aviaLogging.Config
	if path == "console" {
		config = aviaLogging.Config{
			Level:               arclog.InfoLevel,
			StdoutLoggingConfig: &aviaLogging.StdoutLoggingConfig{},
		}
	} else {
		config = aviaLogging.Config{
			Level: arclog.InfoLevel,
			FileLoggingConfig: &aviaLogging.FileLoggingConfig{
				FilePath:  path,
				LogFormat: aviaLogging.JSON,
			},
		}
	}
	ytFileLogger, err := aviaLogging.NewLogger(&config)
	if err != nil {
		return nil, fmt.Errorf("couldn't create YtFile logger %s. Error: %s", path, err)
	}

	return &Logger{
		ytFileLogger: ytFileLogger,
	}, nil
}

func (ytLogger *Logger) Log(record Record) {
	jsonRecord, _ := json.Marshal(record)
	logMessage := string(jsonRecord)
	ytLogger.ytFileLogger.Info(logMessage)
}
