# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

from library.python.gunicorn import run_standalone

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.ticket_daemon.ticket_daemon.settings')


def gunicorn():
    from travel.avia.ticket_daemon import wsgi

    run_standalone(wsgi.application)


def manage():
    from django.core.management import execute_from_command_line

    print('Loading manage.py')
    execute_from_command_line(sys.argv)


def celery():
    import django
    from django.conf import settings

    settings.FAIL_ON_USING_DB_WITHOUT_CONTEXT = False

    django.setup()

    from travel.avia.ticket_daemon.ticket_daemon.daemon.tasks import celery_app

    celery_app.start()


def celery_old():
    import django
    from django.conf import settings

    settings.FAIL_ON_USING_DB_WITHOUT_CONTEXT = False

    django.setup()

    from travel.avia.ticket_daemon.ticket_daemon.daemon.tasks_old import celery_app

    celery_app.start()
