PY2TEST()

OWNER(g:avia)

PEERDIR(
    travel/avia/library/python/tester
    travel/avia/ticket_daemon
    travel/avia/library/python/proxy_pool
    travel/avia/library/python/sirena_client/django

    contrib/python/factory-boy
    contrib/python/Faker
    contrib/python/freezegun
    contrib/python/pytest-httpretty
    contrib/python/mock
    contrib/python/more-itertools
    contrib/python/PyHamcrest
    contrib/python/requests-mock
    contrib/python/six
    contrib/python/text-unidecode
)

IF(NOT SKIP_TESTS_RECIPE)
    INCLUDE(${ARCADIA_ROOT}/travel/avia/library/python/recipe/recipe.inc)
ENDIF()

PY_SRCS(
    conftest.py
    tests_settings.py
    api/factories.py
    api/selfbook/factories.py
    daemon/fake_module_with_None_query.py
    daemon/fake_module_without_query.py
    lib/sample_search_result_provider.py
    partners/__init__.py
    partners/helper.py
    views/redirect/utils.py
)

TEST_SRCS(
    api/models_utils/test_search_codes.py
    api/models_utils/test_settlement_ids_by_airport_id.py
    api/selfbook/test_partner_national_directions.py
    api/selfbook/test_selfbook_empty_rules.py
    api/test_api_result_add_price_prediction.py
    api/test_api_result_filter_bad_variants.py
    api/test_api_result_filter_is_not_circle_variant.py
    api/test_api_result_filter_too_fast_moscow_erevan.py
    api/test_api_result_filter_variants_bad_flight_number.py
    api/test_api_result_filter_visa_required.py
    api/test_api_result_set_partners_statuses.py
    api/test_baggage.py
    api/test_by_flights_key.py
    api/test_currency_cache.py
    api/test_flight_complete_stations.py
    api/test_flight_fabric.py
    api/test_flights_flight_key.py
    api/test_namedtuplequeryset.py
    api/test_queryblacklist.py
    api/test_redirectors_functions.py
    api/test_reference_company_codes.py
    api/test_reference_complete_flights_company.py
    api/test_regionalization.py
    api/test_result_serialization.py
    daemon/extended_fares/test_extended_fares_comparator.py
    daemon/extended_fares/test_fare_extender.py
    daemon/test_application.py
    daemon/test_big_beauty_collector.py
    daemon/test_closing_db.py
    daemon/test_importer.py
    daemon/test_response_collector.py
    daemon/test_variants_saver.py
    lib/test_baggage.py
    lib/test_baggage_corrector.py
    lib/test_baggage_merger.py
    lib/test_baggage_parser.py
    lib/test_big_beauty_sorter.py
    lib/test_http.py
    lib/test_ipc.py
    lib/test_mcr_keys.py
    lib/test_partner_status_fetcher.py
    lib/test_partner_store_time_provider.py
    lib/test_query_partner_provider.py
    lib/test_revise.py
    lib/test_tracker.py
    lib/test_utils.py
    lib/sirena/test_variant.py
    lib/yt_loggers/test_min_price_logger.py
    lib/yt_loggers/test_query_cache_hit_logger.py
    lib/yt_loggers/test_search_result_logger.py
    lib/yt_loggers/test_variants_logger.py
    lib/yt_loggers/test_variants_logger2.py
    lib/yt_loggers/test_wizard_search_result_logger.py
    partners/test_aegean.py
    partners/test_aeroflot4.py
    partners/test_aerotur.py
    partners/test_agent3.py
    partners/test_amadeus.py
    partners/test_anywayanyday.py
    partners/test_aviakass.py
    partners/test_aviaoperator.py
    partners/test_azimuth.py
    partners/test_azimuth2.py
    partners/test_biletdv.py
    partners/test_biletik5.py
    partners/test_biletik6.py
    partners/test_biletinet.py
    partners/test_biletix.py
    partners/test_biletix_kz.py
    partners/test_bookandtrip.py
    partners/test_chabooka.py
    partners/test_charterbilet.py
    partners/test_charterbilet2.py
    partners/test_charterok.py
    partners/test_chartex.py
    partners/test_citytravel.py
    partners/test_citytravel2.py
    partners/test_clickavia.py
    partners/test_csa.py
    partners/test_ctrip3.py
    partners/test_defaults.py
    partners/test_deltatours.py
    partners/test_dohop.py
    partners/test_etraveli.py
    partners/test_euroset.py
    partners/test_expressavia4.py
    partners/test_flyone.py
    partners/test_flyone2.py
    partners/test_justtravel.py
    partners/test_kiwi.py
    partners/test_kupibilet.py
    partners/test_megotravel.py
    partners/test_moireis.py
    partners/test_mytrip.py
    partners/test_nabortu.py
    partners/test_nebotravel.py
    partners/test_nemo.py
    partners/test_onetwotrip32.py
    partners/test_onetwotrip33.py
    partners/test_onetwotrip34.py
    partners/test_onetwotrip35.py
    partners/test_ozon2.py
    partners/test_pobeda8.py
    partners/test_pososhok.py
    partners/test_redwings.py
    partners/test_rusline5.py
    partners/test_s_seven6.py
    partners/test_s_seven_testing.py
    partners/test_sindbad.py
    partners/test_smartavia.py
    partners/test_smartavia2.py
    partners/test_superkassa2.py
    partners/test_supersaver.py
    partners/test_supersaver2.py
    partners/test_svyaznoy.py
    partners/test_tez_tour.py
    partners/test_ticketsua.py
    partners/test_tinkoff.py
    partners/test_travelgenio.py
    partners/test_tripsta.py
    partners/test_tutu.py
    partners/test_ufs_plane.py
    partners/test_uralairlines3.py
    partners/test_uralairlines4.py
    partners/test_uralairlines4_plus.py
    partners/test_uralairlines5.py
    partners/test_utair2.py
    partners/test_utair3.py
    views/redirect/test_dohop.py
    views/redirect/test_pilotua.py
    views/redirect/test_view.py
    views/test_book_view.py
)

RESOURCE_FILES(
    PREFIX travel/avia/ticket_daemon/tests/

    api/result_serialization_data.json
    api/result_serialization_with_fare_families_data.json
    samples/sample_search_result.json

    partners/fixtures/aegean_oneway.json
    partners/fixtures/aegean_oneway_expected.json
    partners/fixtures/aegean_roundtrip.json
    partners/fixtures/aegean_roundtrip_expected.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_booking_info.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot_booking_info.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_children.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot_children.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_cyrillic_error.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_empty_result.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_errors.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_one_flight_many_fares.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot_one_flight_many_fares.xml
    partners/fixtures/aeroflot/aeroflot4/aeroflot_round_trip.json
    partners/fixtures/aeroflot/aeroflot4/aeroflot_round_trip.xml
    partners/fixtures/agent3_oneway.json
    partners/fixtures/agent3_oneway.xml
    partners/fixtures/agent3_twoway.json
    partners/fixtures/agent3_twoway.xml
    partners/fixtures/amadeus.json
    partners/fixtures/amadeus_expected.json
    partners/fixtures/anywayanyday_oneway.json
    partners/fixtures/anywayanyday_oneway_expected.json
    partners/fixtures/anywayanyday_return.json
    partners/fixtures/anywayanyday_return_expected.json
    partners/fixtures/aviakass4.json
    partners/fixtures/aviakass4.xml
    partners/fixtures/aviakass5.json
    partners/fixtures/aviakass5.xml
    partners/fixtures/aviakass5_bad_class_error.xml
    partners/fixtures/aviakass5_empty_variant.xml
    partners/fixtures/aviakass5_past_date_error.xml
    partners/fixtures/aviaoperator2.xml
    partners/fixtures/aviaoperator2.json
    partners/fixtures/aviaoperator2_baggage.xml
    partners/fixtures/aviaoperator2_baggage.json
    partners/fixtures/azimuth_one_way.xml
    partners/fixtures/azimuth_oneway.json
    partners/fixtures/azimuth_return.json
    partners/fixtures/azimuth_return.xml
    partners/fixtures/azimuth2_bad_child_only.json
    partners/fixtures/azimuth2_bad_child_only.xml
    partners/fixtures/azimuth2_bad_fares_structure.json
    partners/fixtures/azimuth2_bad_fares_structure.xml
    partners/fixtures/azimuth2_bad_no_fares.json
    partners/fixtures/azimuth2_bad_no_fares.xml
    partners/fixtures/azimuth2_multi_round.json
    partners/fixtures/azimuth2_multi_round.xml
    partners/fixtures/azimuth2_one_way.json
    partners/fixtures/azimuth2_one_way.xml
    partners/fixtures/azimuth2_return.json
    partners/fixtures/azimuth2_return.xml
    partners/fixtures/azimuth2_return_connection.json
    partners/fixtures/azimuth2_return_connection.xml
    partners/fixtures/biletdv.xml
    partners/fixtures/biletdv.json
    partners/fixtures/biletdv_baggage.xml
    partners/fixtures/biletdv_baggage.json
    partners/fixtures/biletik5_oneway.json
    partners/fixtures/biletik5_oneway.xml
    partners/fixtures/biletik5_twoway.json
    partners/fixtures/biletik5_twoway.xml
    partners/fixtures/biletik6.json
    partners/fixtures/biletik6_expected.json
    partners/fixtures/biletinet.json
    partners/fixtures/biletinet.xml
    partners/fixtures/biletix2.xml
    partners/fixtures/biletix_kz.json
    partners/fixtures/biletix_kz.xml
    partners/fixtures/bookandtrip.xml
    partners/fixtures/bookandtrip.json
    partners/fixtures/bookandtrip_empty.xml
    partners/fixtures/chabooka2.xml
    partners/fixtures/chabooka_expected.json
    partners/fixtures/charterbilet.xml
    partners/fixtures/charterok.xml
    partners/fixtures/chartex_expected.json
    partners/fixtures/chartex_info.xml
    partners/fixtures/chartex_pages.xml
    partners/fixtures/citytravel.json
    partners/fixtures/citytravel.xml
    partners/fixtures/citytravel2.json
    partners/fixtures/citytravel2.xml
    partners/fixtures/citytravel2_fare_codes.xml
    partners/fixtures/citytravel2_fare_codes_result.json
    partners/fixtures/citytravel_fare_codes.xml
    partners/fixtures/citytravel_fare_codes_result.json
    partners/fixtures/clickavia.xml
    partners/fixtures/clickavia.json
    partners/fixtures/clickavia_selfconnect.xml
    partners/fixtures/clickavia_selfconnect.json
    partners/fixtures/clickavia_transfers.xml
    partners/fixtures/clickavia_transfers.json
    partners/fixtures/csa.xml
    partners/fixtures/csa_expected.json
    partners/fixtures/ctrip_baggage_info.json
    partners/fixtures/ctrip_baggage_info_expected.json
    partners/fixtures/ctrip_baggage_info_no_tag.json
    partners/fixtures/ctrip_baggage_info_no_tag_expected.json
    partners/fixtures/ctrip_baggage_info_one_way.json
    partners/fixtures/ctrip_baggage_info_one_way_expected.json
    partners/fixtures/ctrip_oneway.json
    partners/fixtures/ctrip_oneway_expected.json
    partners/fixtures/ctrip_return.json
    partners/fixtures/ctrip_return_expected.json
    partners/fixtures/ctrip_return_group_ids_combined.json
    partners/fixtures/ctrip_return_group_ids_combined_expected.json
    partners/fixtures/deltatours2.xml
    partners/fixtures/deltatours2.json
    partners/fixtures/euroset.xml
    partners/fixtures/euroset.json
    partners/fixtures/expressavia3.json
    partners/fixtures/expressavia3.xml
    partners/fixtures/expressavia4.json
    partners/fixtures/expressavia4.xml
    partners/fixtures/flyone2_oneway.json
    partners/fixtures/flyone2_oneway_expected.json
    partners/fixtures/flyone2_roundtrip.json
    partners/fixtures/flyone2_roundtrip_expected.json
    partners/fixtures/flyone_oneway.json
    partners/fixtures/flyone_oneway_expected.json
    partners/fixtures/flyone_roundtrip.json
    partners/fixtures/flyone_roundtrip_expected.json
    partners/fixtures/gotogate.json
    partners/fixtures/gotogate_one_way_expected.json
    partners/fixtures/justtravel.json
    partners/fixtures/justtravel_auth.json
    partners/fixtures/kiwi_one_way.json
    partners/fixtures/kiwi_one_way_expected.json
    partners/fixtures/kiwi_return.json
    partners/fixtures/kiwi_return_expected.json
    partners/fixtures/kiwi_selfconnect.json
    partners/fixtures/kiwi_selfconnect_expected.json
    partners/fixtures/kupibilet.xml
    partners/fixtures/kupibilet.json
    partners/fixtures/kupibilet_bad_baggage.xml
    partners/fixtures/kupibilet_bad_baggage_expected.json
    partners/fixtures/megotravel.json
    partners/fixtures/megotravel.xml
    partners/fixtures/moireis.xml
    partners/fixtures/moireis.json
    partners/fixtures/moireis_no_baggage.xml
    partners/fixtures/moireis_no_baggage.json
    partners/fixtures/mytrip.json
    partners/fixtures/mytrip_one_way_expected.json
    partners/fixtures/nabortu.xml
    partners/fixtures/nebotravel.xml
    partners/fixtures/nebotravel_expected.json
    partners/fixtures/nemo_errors.xml
    partners/fixtures/onetwotrip32.json
    partners/fixtures/onetwotrip32_expected.json
    partners/fixtures/onetwotrip32_bad_baggage.json
    partners/fixtures/onetwotrip32_bad_baggage_expected.json
    partners/fixtures/onetwotrip33.xml
    partners/fixtures/onetwotrip33_expected.json
    partners/fixtures/onetwotrip34.xml
    partners/fixtures/onetwotrip34_expected.json
    partners/fixtures/onetwotrip35.xml
    partners/fixtures/onetwotrip35_bad_op.xml
    partners/fixtures/onetwotrip35_bad_op_expected.json
    partners/fixtures/onetwotrip35_expected.json
    partners/fixtures/ozon.xml
    partners/fixtures/ozon.json
    partners/fixtures/ozon2.json
    partners/fixtures/ozon2_expected.json
    partners/fixtures/pobeda2.json
    partners/fixtures/pobeda2_expected.json
    partners/fixtures/pobeda3.json
    partners/fixtures/pobeda3_expected.json
    partners/fixtures/pobeda4.json
    partners/fixtures/pobeda4_expected.json
    partners/fixtures/pobeda4_infants.json
    partners/fixtures/pobeda4_infants_expected.json
    partners/fixtures/pobeda5.json
    partners/fixtures/pobeda5_expected.json
    partners/fixtures/pobeda5_infants.json
    partners/fixtures/pobeda5_infants_expected.json
    partners/fixtures/pobeda6.json
    partners/fixtures/pobeda6_expected.json
    partners/fixtures/pobeda6_filter_route_pairs.json
    partners/fixtures/pobeda6_filter_route_pairs_expected.json
    partners/fixtures/pobeda6_infants.json
    partners/fixtures/pobeda6_infants_expected.json
    partners/fixtures/pobeda7.json
    partners/fixtures/pobeda7_expected.json
    partners/fixtures/pobeda7_extended_baggage.json
    partners/fixtures/pobeda7_extended_baggage_expected.json
    partners/fixtures/pobeda7_filter_route_pairs.json
    partners/fixtures/pobeda7_filter_route_pairs_expected.json
    partners/fixtures/pobeda7_infants.json
    partners/fixtures/pobeda7_infants_expected.json
    partners/fixtures/pobeda7_new_deeplink.json
    partners/fixtures/pobeda7_new_deeplink_expected.json
    partners/fixtures/pobeda7_no_10kg_price.json
    partners/fixtures/pobeda7_no_10kg_price_expected.json
    partners/fixtures/pobeda8.json
    partners/fixtures/pobeda8_expected.json
    partners/fixtures/pobeda8_extended_baggage.json
    partners/fixtures/pobeda8_extended_baggage_expected.json
    partners/fixtures/pobeda8_filter_route_pairs.json
    partners/fixtures/pobeda8_filter_route_pairs_expected.json
    partners/fixtures/pobeda8_infants.json
    partners/fixtures/pobeda8_infants_expected.json
    partners/fixtures/pobeda8_new_deeplink.json
    partners/fixtures/pobeda8_new_deeplink_expected.json
    partners/fixtures/pobeda8_no_10kg_price.json
    partners/fixtures/pobeda8_no_10kg_price_expected.json
    partners/fixtures/pososhok.xml
    partners/fixtures/redwings_empty_response.xml
    partners/fixtures/redwings_ow.json
    partners/fixtures/redwings_ow_response.xml
    partners/fixtures/redwings_return_321.json
    partners/fixtures/redwings_return_321_response.xml
    partners/fixtures/redwings_return_rtw.json
    partners/fixtures/redwings_return_rtw_response.xml
    partners/fixtures/redwings_return_svx.json
    partners/fixtures/redwings_return_svx_response.xml
    partners/fixtures/rusline3_nemo.json
    partners/fixtures/rusline3_nemo.xml
    partners/fixtures/rusline3_nemo_empty.xml
    partners/fixtures/rusline3_nemo_without_fare_code.json
    partners/fixtures/rusline3_nemo_without_fare_code.xml
    partners/fixtures/rusline4_sig.json
    partners/fixtures/rusline4_sig.xml
    partners/fixtures/rusline4_sig_empty.xml
    partners/fixtures/s_seven3_diff_cur_KZT_oneway_result.json
    partners/fixtures/s_seven3_one_way.xml
    partners/fixtures/s_seven3_oneway_result.json
    partners/fixtures/s_seven3_two_ways.xml
    partners/fixtures/s_seven3_two_ways_result.json
    partners/fixtures/s_seven4_diff_cur_KZT_oneway_result.json
    partners/fixtures/s_seven4_one_way.xml
    partners/fixtures/s_seven4_oneway_result.json
    partners/fixtures/s_seven4_two_ways.xml
    partners/fixtures/s_seven4_two_ways_result.json
    partners/fixtures/s_seven5_diff_cur_KZT_oneway_result.json
    partners/fixtures/s_seven5_one_way.xml
    partners/fixtures/s_seven5_oneway_result.json
    partners/fixtures/s_seven6_cyrillic_code.xml
    partners/fixtures/s_seven6_diff_cur_KZT_oneway_result.json
    partners/fixtures/s_seven6_far_date.xml
    partners/fixtures/s_seven6_one_way.xml
    partners/fixtures/s_seven6_oneway_result.json
    partners/fixtures/s_seven6_past_date.xml
    partners/fixtures/s_seven6_unknown_error.xml
    partners/fixtures/s_seven_testing_diff_cur_KZT_oneway_result.json
    partners/fixtures/s_seven_testing_one_way.xml
    partners/fixtures/s_seven_testing_oneway_result.json
    partners/fixtures/sindbad2.xml
    partners/fixtures/sindbad2.json
    partners/fixtures/smartavia_oneway.json
    partners/fixtures/smartavia_oneway_expected.json
    partners/fixtures/smartavia_roundtrip.json
    partners/fixtures/smartavia_roundtrip_expected.json
    partners/fixtures/superkassa2.json
    partners/fixtures/superkassa2.xml
    partners/fixtures/superkassa2_bad_baggage.json
    partners/fixtures/superkassa2_bad_baggage.xml
    partners/fixtures/superkassa2_fare_codes.xml
    partners/fixtures/superkassa2_fare_codes_expected.json
    partners/fixtures/supersaver2_one_way.json
    partners/fixtures/supersaver2_one_way_expected.json
    partners/fixtures/supersaver2_round_trip.json
    partners/fixtures/supersaver2_round_trip_expected.json
    partners/fixtures/supersaver_one_way.xml
    partners/fixtures/supersaver_one_way_result.json
    partners/fixtures/supersaver_return.xml
    partners/fixtures/supersaver_return_result.json
    partners/fixtures/svyaznoy4.json
    partners/fixtures/svyaznoy4_expected.json
    partners/fixtures/tez_tour-one-way.json
    partners/fixtures/tez_tour-one-way.xml
    partners/fixtures/tez_tour-two-way.json
    partners/fixtures/tez_tour-two-way.xml
    partners/fixtures/ticketsua2.xml
    partners/fixtures/tinkoff.xml
    partners/fixtures/tinkoff.json
    partners/fixtures/tinkoff2_oneway.xml
    partners/fixtures/tinkoff2_oneway_expected.json
    partners/fixtures/tinkoff2_return.xml
    partners/fixtures/tinkoff2_return_expected.json
    partners/fixtures/travelgenio_empty.xml
    partners/fixtures/travelgenio_one_way.xml
    partners/fixtures/travelgenio_one_way.json
    partners/fixtures/travelgenio_return.xml
    partners/fixtures/travelgenio_return.json
    partners/fixtures/trip_ru3_etraveli.json
    partners/fixtures/trip_ru3_etraveli_expected.json
    partners/fixtures/trip_ru_bad_baggage.json
    partners/fixtures/trip_ru_bad_baggage_expected.json
    partners/fixtures/trip_ru_new_format.json
    partners/fixtures/trip_ru_new_format_expected.json
    partners/fixtures/trip_ru_one_way.json
    partners/fixtures/trip_ru_one_way_expected.json
    partners/fixtures/trip_ru_return.json
    partners/fixtures/trip_ru_return_expected.json
    partners/fixtures/trip_ru_stopover.json
    partners/fixtures/trip_ru_stopover_expected.json
    partners/fixtures/tripsta5.xml
    partners/fixtures/tripsta5.json
    partners/fixtures/tutu.json
    partners/fixtures/tutu_expected.json
    partners/fixtures/ufs_plane2-one_way.xml
    partners/fixtures/ufs_plane2-one_way.json
    partners/fixtures/uralairlines2_oneway.json
    partners/fixtures/uralairlines2_oneway.xml
    partners/fixtures/uralairlines2_return.json
    partners/fixtures/uralairlines2_return.xml
    partners/fixtures/uralairlines3_oneway.json
    partners/fixtures/uralairlines3_oneway.xml
    partners/fixtures/uralairlines3_return.json
    partners/fixtures/uralairlines3_return.xml
    partners/fixtures/uralairlines4_oneway.json
    partners/fixtures/uralairlines4_oneway_plus.json
    partners/fixtures/uralairlines4_oneway.xml
    partners/fixtures/uralairlines4_return.json
    partners/fixtures/uralairlines4_return_plus.json
    partners/fixtures/uralairlines4_return.xml
    partners/fixtures/uralairlines4_return_plus.xml
    partners/fixtures/uralairlines5_oneway.json
    partners/fixtures/uralairlines5_oneway.xml
    partners/fixtures/uralairlines5_return.json
    partners/fixtures/uralairlines5_return.xml
    partners/fixtures/uralairlines_oneway.json
    partners/fixtures/uralairlines_oneway.xml
    partners/fixtures/uralairlines_return.json
    partners/fixtures/uralairlines_return.xml
    partners/fixtures/utair.json
    partners/fixtures/utair.xml
    partners/fixtures/utair2.json
    partners/fixtures/utair2.xml
    partners/fixtures/utair2_baggage.json
    partners/fixtures/utair2_baggage.xml
    partners/fixtures/utair3.json
    partners/fixtures/utair3.xml
    partners/fixtures/utair3_baggage.json
    partners/fixtures/utair3_baggage.xml
    partners/fixtures/utair_baggage.json
    partners/fixtures/utair_baggage.xml
    partners/fixtures/uzairways3.json
    partners/fixtures/uzairways3.xml
)

SIZE(MEDIUM)

ENV(DJANGO_SETTINGS_MODULE=travel.avia.ticket_daemon.tests.tests_settings)
NO_CHECK_IMPORTS(
    travel.avia.ticket_daemon.gunicorn_conf
    travel.avia.library.*
    django_redis.*
)
END()
