# -*- coding: utf-8 -*-
# flake8: noqa
from travel.avia.library.python.django_namedtuples import patch_django_queryset
from travel.avia.library.python.ticket_daemon.caches.services import *  # for cache warmup
from travel.avia.ticket_daemon.ticket_daemon.lib.timer import Timer

from .company import *
from .conversions import *
from .country import *
from .currency import *
from .point import *
from .region import *
from .registry import *
from .search_codes import *
from .settlement import *
from .station import *
from .top_flights import *

patch_django_queryset()


def warm_up_cache(logger):
    timer = Timer()
    _id = str(timer.start_time.strftime('%d:%H%M%S.%f'))
    logger.info('Warm up worker [%s]', _id)

    for group in SimpleWarmGroup.get_groups():
        group.warm_up(logger)

    logger.info('Warm up done   [%s] elapsed %s ms',
                _id, int(timer.get_elapsed_seconds() * 1000))
