# -*- coding: utf-8 -*-
import logging
from datetime import datetime

from django.conf import settings

from travel.avia.library.python.ticket_daemon.memo import SimpleWarmGroup, memoize

PARTNER_CONVERSIONS_YT_SOURCE = '//home/avia/reports/conversion_partners_sources'
conversions_warm_group = SimpleWarmGroup('conversions')
logger = logging.getLogger(__name__)


def get_yt_client():
    from yt.wrapper import YtClient
    return YtClient(
        proxy=settings.YT_PROXY,
        token=settings.YT_TOKEN,
        config={
            'operation_tracker': {
                'stderr_logging_level': 'WARNING',
                'progress_logging_level': 'WARNING',
            },
            'read_retries': {
                'enable': True
            },
            'clear_local_temp_files': True,
        },
    )


def get_last_table(ytc, path):
    tables = []

    for table in ytc.search(path, node_type='table'):
        try:
            table_date = datetime.strptime(table.split('/')[-1], '%Y-%m-%d').date()
        except ValueError:
            continue

        tables.append((
            table_date,
            table
        ))

    return sorted(tables, reverse=True)[0][1]


@conversions_warm_group
@memoize()
def _conversions():
    conversions = {}
    try:
        ytc = get_yt_client()
        table = get_last_table(ytc, PARTNER_CONVERSIONS_YT_SOURCE)

        conversions = {
            record['billing_order_id']: record['conversion']
            for record in ytc.read_table(table)
            if record['source'] == 'direct_wizard'
        }
    except Exception:
        pass
    if not conversions:
        logger.exception('Conversion info is not loaded')
    return conversions


def get_conversion(billing_order_id):
    conversions = _conversions()
    return conversions.get(billing_order_id, 0)
