# -*- coding: utf-8 -*-
from travel.avia.library.python.common.models.geo import Country
from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup

from travel.avia.ticket_daemon.ticket_daemon.api.models_utils.settlement import _settlement_by_id
from travel.avia.ticket_daemon.ticket_daemon.api.models_utils.station import _airport_by_id


@SimpleWarmGroup('country')
@memoize()
def _countries():
    joint_ids = set(
        c.country_id for c in _airport_by_id().values()
    ) & set(
        c.country_id for c in _settlement_by_id().values()
    )

    return tuple(
        Country.objects.filter(id__in=joint_ids)
        .namedtuples('id', 'code', '_geo_id')
    )


@SimpleWarmGroup('country')
@memoize()
def _country_by_id():
    return {c.id: c for c in _countries()}


@SimpleWarmGroup('country')
@memoize()
def _country_by_geoid():
    return {c.geo_id: c for c in _countries() if c.geo_id}


def get_country_by_id(country_id):
    return _country_by_id().get(country_id)


def get_country_by_geoid(geo_id):
    return _country_by_geoid().get(geo_id)
