# -*- coding: utf-8 -*-
from travel.avia.library.python.common.models.currency import Currency
from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup


@SimpleWarmGroup('currency')
@memoize()
def _currency_by_id():
    return {c.id: c for c in Currency.objects.all().namedtuples('id', 'code')}


@SimpleWarmGroup('currency')
@memoize()
def _currency_by_code():
    return {c.code: c for c in _currency_by_id().values()}


def get_currency_by_id(currency_id):
    return _currency_by_id().get(currency_id)


def get_currency_id_by_code(currency_code):
    currency = _currency_by_code().get(currency_code)
    if currency:
        return currency.id
    return None
